/*
 * ErrorHandler.c
 *
 *  Created on: Oct 8, 2010
 *      Author: prsrinivasan
 */

#include <error_handler.h>
#include <hash_utils.h>

#include <normalize.h>
#include <bidi_rules.h>
#include <contextual_rules.h>
#include <xcode_config.h>
#include <stdio.h>
#include <unicode_dataloader.h>

void addErrorCode(int error_code, char *error_code_msg) {
	g_hash_table_insert(unicodeData->IDNA_ERROR_CODES_TABLE, mallocAndSetInt(error_code),
			mallocAndSetString(error_code_msg));
}

void logError(int error_code) {
#ifdef IDNA_DEBUG_ON
	char* error_msg = (char *) g_hash_table_lookup(
			unicodeData->IDNA_ERROR_CODES_TABLE, &error_code);        
	if (error_msg != NULL) {
		fprintf(stderr, "error_code : %d\n  error_msg : %s\n", error_code, error_msg);
	}
#endif
}

void initNormalizationErrorCodes() {
	addErrorCode(XCODE_NORMALIZE_EXPANSIONERROR,
			"XCODE_NORMALIZE_EXPANSIONERROR");
	addErrorCode(XCODE_NORMALIZE_PROHIBITEDCHAR,
			"XCODE_NORMALIZE_PROHIBITEDCHAR");
	addErrorCode(XCODE_NORMALIZE_NULL_CHARACTER_PRESENT,
			"XCODE_NORMALIZE_NULL_CHARACTER_PRESENT");
	addErrorCode(XCODE_NORMALIZE_FIRSTLAST_BIDIERROR,
			"XCODE_NORMALIZE_FIRSTLAST_BIDIERROR");
	addErrorCode(XCODE_NORMALIZE_MIXED_BIDIERROR,
			"XCODE_NORMALIZE_MIXED_BIDIERROR");
	addErrorCode(XCODE_NORMALIZE_BAD_ARGUMENT_ERROR,
			"XCODE_NORMALIZE_BAD_ARGUMENT_ERROR");
	addErrorCode(XCODE_NORMALIZE_MEMORY_ALLOCATION_ERROR,
			"XCODE_NORMALIZE_MEMORY_ALLOCATION_ERROR");
	addErrorCode(XCODE_NORMALIZE_BUFFER_OVERFLOW_ERROR,
			"XCODE_NORMALIZE_BUFFER_OVERFLOW_ERROR");
	addErrorCode(XCODE_NORMALIZE_MAPPEDOUT, "XCODE_NORMALIZE_MAPPEDOUT");
	addErrorCode(XCODE_NORMALIZE_OUTOFRANGEERROR,
			"XCODE_NORMALIZE_OUTOFRANGEERROR");
	addErrorCode(XCODE_NORMALIZE_NOT_IN_NFC_FORM,
			"XCODE_NORMALIZE_NOT_IN_NFC_FORM");
}

void initContextualErrorCodes() {
	addErrorCode(XCODE_CTXRULE_FAIL, XCODE_CTXRULE_FAIL_MSG);
	addErrorCode(XCODE_CTXRULE_NOT_APPLICABLE_FAIL,
			XCODE_CTXRULE_NOT_APPLICABLE_FAIL_MSG);
	addErrorCode(XCODE_CTXRULE_ZERO_WIDTH_NON_JOINER_FAIL,
			XCODE_CTXRULE_ZERO_WIDTH_NON_JOINER_FAIL_MSG);
	addErrorCode(XCODE_CTXRULE_ZERO_WIDTH_JOINER_FAIL,
			XCODE_CTXRULE_ZERO_WIDTH_JOINER_FAIL_MSG);
	addErrorCode(XCODE_CTXRULE_MIDDLE_DOT_FAIL,
			XCODE_CTXRULE_MIDDLE_DOT_FAIL_MSG);
	addErrorCode(XCODE_CTXRULE_GREEK_LOWER_NUMERAL_FAIL,
			XCODE_CTXRULE_GREEK_LOWER_NUMERAL_FAIL_MSG);
	addErrorCode(XCODE_CTXRULE_HEBREW_PUNCUTATION_GERESH_FAIL,
			XCODE_CTXRULE_HEBREW_PUNCUTATION_GERESH_FAIL_MSG);
	addErrorCode(XCODE_CTXRULE_HEBREW_PUNCUTATION_GERSHAYIM_FAIL,
			XCODE_CTXRULE_HEBREW_PUNCUTATION_GERSHAYIM_FAIL_MSG);
	addErrorCode(XCODE_CTXRULE_KATAKANA_MIDDLE_DOT_FAIL,
			XCODE_CTXRULE_KATAKANA_MIDDLE_DOT_FAIL_MSG);
	addErrorCode(XCODE_CTXRULE_ARABIC_INDIC_DIGITS_FAIL,
			XCODE_CTXRULE_ARABIC_INDIC_DIGITS_FAIL_MSG);
	addErrorCode(XCODE_CTXRULE_EXT_ARABIC_INDIC_DIGITS_FAIL,
			XCODE_CTXRULE_EXT_ARABIC_INDIC_DIGITS_FAIL_MSG);

}

void initBIDIErrorCodes() {
	addErrorCode(XCODE_BIDIRULE_FAIL, XCODE_BIDIRULE_FAIL_MSG);
	addErrorCode(XCODE_BIDIRULE_ONE_FAIL, XCODE_BIDIRULE_ONE_FAIL_MSG);
	addErrorCode(XCODE_BIDIRULE_TWO_FAIL, XCODE_BIDIRULE_TWO_FAIL_MSG);
	addErrorCode(XCODE_BIDIRULE_THREE_FAIL, XCODE_BIDIRULE_THREE_FAIL_MSG);
	addErrorCode(XCODE_BIDIRULE_FOUR_FAIL, XCODE_BIDIRULE_FOUR_FAIL_MSG);
	addErrorCode(XCODE_BIDIRULE_FIVE_FAIL, XCODE_BIDIRULE_FIVE_FAIL_MSG);
	addErrorCode(XCODE_BIDIRULE_SIX_FAIL, XCODE_BIDIRULE_SIX_FAIL_MSG);
}

void initToXXXErrorCodes() {
	addErrorCode(XCODE_TOXXX_STD3_NONLDH, "XCODE_TOXXX_STD3_NONLDH");
	addErrorCode(XCODE_TOXXX_STD3_HYPHENERROR, "XCODE_TOXXX_STD3_HYPHENERROR");
	addErrorCode(XCODE_TOXXX_ALREADYENCODED, "XCODE_TOXXX_ALREADYENCODED");
	addErrorCode(XCODE_TOXXX_INVALIDDNSLEN, "XCODE_TOXXX_INVALIDDNSLEN");
	addErrorCode(XCODE_TOXXX_CIRCLECHECKFAILED, "XCODE_TOXXX_CIRCLECHECKFAILED");
}

void initErrorCodes() {
	unicodeData->IDNA_ERROR_CODES_TABLE = g_hash_table_new_full(g_int_hash, g_int_equal,
			freeInt, freeString);

	initNormalizationErrorCodes();
	initContextualErrorCodes();
	initBIDIErrorCodes();
	initToXXXErrorCodes();
}

