/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.util;

public class XcodeException
extends Exception {
    private static final long serialVersionUID = 128648304940948516L;
    private final int code;
    private final String message;
    private final Throwable parent;

    public XcodeException(int code, String message) {
        this(code, message, null);
    }

    public XcodeException(XcodeException x, Throwable parent) {
        this(x.code, x.message, parent);
    }

    public XcodeException(XcodeException x, String message) {
        this(x.code, x.message + message, x.parent);
    }

    public XcodeException(int code, String message, Throwable parent) {
        super(message);
        this.code = code;
        this.message = message;
        this.parent = parent;
    }

    public int getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        String output = new String();
        if (this.message != null) {
            output = output + this.message;
        }
        if (this.parent != null) {
            output = output + "\n -> " + this.parent.getClass().getName() + ": ";
            String msg = this.parent.getMessage();
            if (msg != null) {
                output = output + msg;
            }
        }
        return output;
    }
}

