/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.ArrayList;

public class XcodeErrorGenerator {
    public static final String EMPTY = "";
    public static final char DELIMITER = '\t';

    public static void usage() {
        System.out.println("usage: java XcodeErrorGenerator <inputfile> <outputfile>");
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            XcodeErrorGenerator.usage();
            return;
        }
        XcodeErrorGenerator.generate(new File(args[0]), new File(args[1]));
    }

    public static String getHeader() {
        String header = new String();
        header = header + "/*\n * This source file is constructed from the ErrorCodes.txt\n";
        header = header + " * file in the data directory.  Do not modify.\n */\n\n";
        header = header + "package com.vgrs.xcode.util;\npublic class XcodeError {\n";
        return header;
    }

    public static String getFooter() {
        return "}\n";
    }

    public static void generate(File input, File output) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(input));
            ArrayList<String> lines = new ArrayList<String>();
            String line = null;
            while ((line = in.readLine()) != null) {
                lines.add(line);
            }
            FileOutputStream fos = new FileOutputStream(output);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            byte[] buffer = XcodeErrorGenerator.getHeader().getBytes();
            bos.write(buffer, 0, buffer.length);
            for (String data : lines) {
                buffer = XcodeErrorGenerator.generate(data).getBytes();
                bos.write(buffer, 0, buffer.length);
            }
            buffer = XcodeErrorGenerator.getFooter().getBytes();
            bos.write(buffer, 0, buffer.length);
            bos.close();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static String generate(String input) throws Exception {
        String msg;
        String name;
        if (input == null) {
            return EMPTY;
        }
        String inputString = input.trim();
        if (inputString.length() == 0 || inputString.charAt(0) == '#') {
            return EMPTY;
        }
        int token = inputString.indexOf(9);
        if (token < 0) {
            throw new Exception("Invalid file format: " + inputString);
        }
        int code = Integer.parseInt(inputString.substring(0, token));
        if ((token = (inputString = inputString.substring(token + 1)).indexOf(9)) < 0) {
            name = inputString;
            msg = EMPTY;
        } else {
            name = inputString.substring(0, token);
            msg = inputString.substring(token + 1);
        }
        String result = "\n\n/*\n * " + name + ": " + code + "\n */\n";
        result = result + " static public XcodeException " + name + "() {\n";
        result = result + "  return new XcodeException(\n";
        result = result + "   " + code + ",\n";
        result = result + "   \"" + msg + "\"\n";
        result = result + "  );\n";
        result = result + " }\n";
        result = result + " static public XcodeException " + name + "(String msg) {\n";
        result = result + "  return new XcodeException(\n";
        result = result + "   " + code + ",\n";
        result = result + "   \"" + msg + ": \"+ msg\n";
        result = result + "  );\n";
        result = result + " }\n";
        result = result + " static public boolean is_" + name + "(XcodeException x) {\n";
        result = result + "  return (x.getCode() == " + code + ");\n";
        result = result + " }\n";
        return result;
    }
}

