/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.util;

import com.vgrs.xcode.common.Range;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.TIntSet;
import java.util.ArrayList;
import java.util.Collection;

public class RangeCreator {
    public static Collection<Range> createRanges(TIntSet aSet) {
        TIntArrayList list = new TIntArrayList(aSet);
        return RangeCreator.createRanges(list);
    }

    public static Collection<Range> createRanges(TIntList aList) {
        ArrayList<Range> ranges = null;
        if (aList == null || aList.isEmpty()) {
            return ranges;
        }
        ranges = new ArrayList<Range>();
        aList.sort();
        int[] inputArray = aList.toArray();
        int first = 0;
        int prev = 0;
        boolean rangeStarted = false;
        int length = inputArray.length;
        int i = 0;
        while (i < length) {
            if (!rangeStarted) {
                prev = first = inputArray[i];
                rangeStarted = true;
            }
            int next = 0;
            if (i + 1 >= length - 1) {
                next = inputArray[i + 1];
                if (next == prev + 1) {
                    ranges.add(new Range(first, next));
                    break;
                }
                ranges.add(new Range(first, prev));
                ranges.add(new Range(next, next));
                break;
            }
            if ((next = inputArray[++i]) > prev + 1) {
                ranges.add(new Range(first, prev));
                rangeStarted = false;
            }
            prev = next;
        }
        return ranges;
    }
}

