/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.util;

import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;

public class Datafile {
    public static final String GZIP_SUFFIX = ".gz";
    public static final String ZIP_SUFFIX = ".zip";
    private static final ClassLoader loader = Datafile.class.getClassLoader();

    public static Iterator<String> getGzipIterator(File aFile) throws XcodeException {
        try {
            return Datafile.readData(new GZIPInputStream(Datafile.getResource(aFile))).iterator();
        }
        catch (IOException e) {
            throw XcodeError.FILE_IO(": '" + aFile + "'");
        }
    }

    public static Iterator<String> getGzipIterator(String aResource) throws XcodeException {
        try {
            return Datafile.readData(new GZIPInputStream(Datafile.getResource(aResource))).iterator();
        }
        catch (IOException e) {
            throw XcodeError.FILE_IO(": '" + aResource + "'");
        }
    }

    public static Iterator<String> getIterator(File aFile) throws XcodeException {
        if (aFile == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        String filename = aFile.getName();
        if (filename.length() == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        if (filename.endsWith(ZIP_SUFFIX)) {
            return Datafile.getZipIterator(aFile);
        }
        if (filename.endsWith(GZIP_SUFFIX)) {
            return Datafile.getGzipIterator(aFile);
        }
        return Datafile.getTxtIterator(aFile);
    }

    public static Iterator<String> getIterator(String aResource) throws XcodeException {
        if (aResource == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aResource.length() == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        if (aResource.endsWith(ZIP_SUFFIX)) {
            return Datafile.getZipIterator(aResource);
        }
        if (aResource.endsWith(GZIP_SUFFIX)) {
            return Datafile.getGzipIterator(aResource);
        }
        return Datafile.getTxtIterator(aResource);
    }

    public static Iterator<String> getTxtIterator(File aFile) throws XcodeException {
        try {
            return Datafile.readData(Datafile.getResource(aFile)).iterator();
        }
        catch (IOException e) {
            throw XcodeError.FILE_IO(": '" + aFile + "'");
        }
    }

    public static Iterator<String> getTxtIterator(String aResource) throws XcodeException {
        try {
            return Datafile.readData(Datafile.getResource(aResource)).iterator();
        }
        catch (IOException e) {
            throw XcodeError.FILE_IO(": '" + aResource + "'");
        }
    }

    public static Iterator<String> getZipIterator(File aFile) throws XcodeException {
        try {
            return Datafile.getZipIterator(new ZipInputStream(Datafile.getResource(aFile)));
        }
        catch (IOException e) {
            throw XcodeError.FILE_IO(": '" + aFile + "'");
        }
    }

    public static Iterator<String> getZipIterator(String aResource) throws XcodeException {
        try {
            return Datafile.getZipIterator(new ZipInputStream(Datafile.getResource(aResource)));
        }
        catch (IOException e) {
            throw XcodeError.FILE_IO(": '" + aResource + "'");
        }
    }

    public static Iterator<String> getZipIterator(ZipInputStream aStream) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        while (aStream.getNextEntry() != null) {
            lines.addAll(Datafile.readData(aStream));
        }
        return lines.iterator();
    }

    private static FileInputStream getResource(File aFile) throws XcodeException {
        try {
            return new FileInputStream(aFile);
        }
        catch (FileNotFoundException e) {
            throw XcodeError.FILE_IO(": '" + aFile + "'");
        }
    }

    private static InputStream getResource(String aResource) throws XcodeException {
        InputStream inputStream = loader.getResourceAsStream(aResource);
        if (inputStream == null) {
            throw XcodeError.FILE_IO(": '" + aResource + "'");
        }
        return inputStream;
    }

    private static ArrayList<String> readData(BufferedReader aBuffer) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        String line = null;
        while ((line = aBuffer.readLine()) != null) {
            lines.add(line);
        }
        return lines;
    }

    private static ArrayList<String> readData(InputStream aStream) throws IOException {
        return Datafile.readData(new BufferedReader(new InputStreamReader(aStream)));
    }
}

