/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.idna.contextualrule;

import com.vgrs.xcode.common.unicodedata.UnicodeData;
import com.vgrs.xcode.idna.CanonicalCombiningClass;
import com.vgrs.xcode.idna.contextualrule.AbstractJoinerCodePointRule;
import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZeroWidthNonJoinerRule
extends AbstractJoinerCodePointRule {
    private static final int ZERO_WIDTH_NON_JOINER = 8204;
    private static final String ZERO_WIDTH_NON_JOINER_UNICODE_CODE_POINT = Integer.toHexString(8204).toUpperCase();
    private static final Pattern JOINING_TYPE = Pattern.compile("(L|D)(T)*200C(T)*(R|D)");

    public ZeroWidthNonJoinerRule() {
        super.setCodePointToWhichRuleApplies(8204);
    }

    @Override
    public void executeRule(int aCodePointIndex, int[] aCodePoints) throws XcodeException {
        if (super.checkIfCpBeforeIsVirama(aCodePointIndex, aCodePoints)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int codePoint : aCodePoints) {
            if (codePoint == 8204) {
                sb.append(ZERO_WIDTH_NON_JOINER_UNICODE_CODE_POINT);
                continue;
            }
            char joiningTypeOfCodePoint = UnicodeData.getJoiningType(codePoint);
            sb.append(joiningTypeOfCodePoint);
        }
        Matcher matcher = JOINING_TYPE.matcher(sb.toString());
        if (!matcher.matches()) {
            throw XcodeError.IDNA_CONTEXTUAL_RULE_VIOLATION(super.getRuleName() + ": Either Canonical Combining Class of code point before " + Integer.toHexString(super.getCodePointToWhichRuleApplies()).toUpperCase() + " must be " + CanonicalCombiningClass.VIRAMA.toString() + " OR should match the regex " + "((Joining_Type:{L,D})(Joining_Type:T)*200C(Joining_Type:T)*(Joining_Type:{R,D})");
        }
    }
}

