/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.idna.contextualrule;

import com.vgrs.xcode.idna.contextualrule.AbstractAllCodePointsNotEvaluated;
import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;

public class MiddleDotRule
extends AbstractAllCodePointsNotEvaluated {
    private static final int MIDDLE_DOT = 183;
    private static final int LATIN_SMALL_LETTER_L = 108;

    public MiddleDotRule() {
        super.setCodePointToWhichRuleApplies(183);
    }

    @Override
    public void executeRule(int aCodePointIndex, int[] aCodePoints) throws XcodeException {
        int length = aCodePoints.length;
        int beforeCpIndex = aCodePointIndex - 1;
        if (beforeCpIndex < 0) {
            throw XcodeError.IDNA_CONTEXTUAL_RULE_VIOLATION(super.getRuleName() + ": Index of code point before MIDDLE_DOT 0x00B7 is < 0");
        }
        int afterCpIndex = aCodePointIndex + 1;
        if (afterCpIndex > length - 1) {
            throw XcodeError.IDNA_CONTEXTUAL_RULE_VIOLATION(super.getRuleName() + ": Index of code point after MIDDLE_DOT 0x00B7 is > length of array");
        }
        if (aCodePoints[beforeCpIndex] != 108 || aCodePoints[afterCpIndex] != 108) {
            throw XcodeError.IDNA_CONTEXTUAL_RULE_VIOLATION(super.getRuleName() + ": Code point before/after MIDDLE DOT (0x00B7) " + "!= LATIN SMALL LETTER L (0x006C)");
        }
    }
}

