/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.idna.contextualrule;

import com.vgrs.xcode.common.unicodedata.UnicodeData;
import com.vgrs.xcode.idna.contextualrule.AbstractAllCodePointsEvaluated;
import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;
import java.util.HashSet;

public class KatakanaMiddleDotRule
extends AbstractAllCodePointsEvaluated {
    private static final int KATAKANA_MIDDLE_DOT = 12539;
    private static final String HAN_SCRIPT = "Han";
    private static final String HIRAGANA_SCRIPT = "Hiragana";
    private static final String KATAKANA_SCRIPT = "Katakana";
    private static final HashSet<String> scriptsRequiredWhenKatakanaMiddleDotPresent = new HashSet();

    public KatakanaMiddleDotRule() {
        super.setCodePointToWhichRuleApplies(12539);
    }

    @Override
    public void executeRule(int aCodePointIndex, int[] aCodePoints) throws XcodeException {
        boolean foundHiraganaKatanaOrHanCharacter = false;
        for (int codePoint : aCodePoints) {
            String script;
            if (codePoint == 12539 || !scriptsRequiredWhenKatakanaMiddleDotPresent.contains(script = UnicodeData.getScript(codePoint))) continue;
            foundHiraganaKatanaOrHanCharacter = true;
            break;
        }
        if (!foundHiraganaKatanaOrHanCharacter) {
            throw XcodeError.IDNA_CONTEXTUAL_RULE_VIOLATION(super.getRuleName() + ": At least one character in a label that has a Katakana Middle Dot (0x30FB) " + "must belong to any of the " + scriptsRequiredWhenKatakanaMiddleDotPresent + " scripts.");
        }
    }

    static {
        scriptsRequiredWhenKatakanaMiddleDotPresent.add(HAN_SCRIPT);
        scriptsRequiredWhenKatakanaMiddleDotPresent.add(HIRAGANA_SCRIPT);
        scriptsRequiredWhenKatakanaMiddleDotPresent.add(KATAKANA_SCRIPT);
    }
}

