/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.idna.contextualrule;

import com.vgrs.xcode.common.unicodedata.UnicodeData;
import com.vgrs.xcode.idna.contextualrule.AbstractAllCodePointsNotEvaluated;
import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;

public class HebrewPunctuationGereshRule
extends AbstractAllCodePointsNotEvaluated {
    private static final int HEBREW_PUNCTUATION_GERESH = 1523;
    private static final String HEBREW_SCRIPT = "Hebrew";

    public HebrewPunctuationGereshRule() {
        super.setCodePointToWhichRuleApplies(1523);
    }

    @Override
    public void executeRule(int aCodePointIndex, int[] aCodePoints) throws XcodeException {
        int beforeCpIndex = aCodePointIndex - 1;
        if (beforeCpIndex < 0) {
            throw XcodeError.IDNA_CONTEXTUAL_RULE_VIOLATION(super.getRuleName() + ": Index of code point before HEBREW_PUNCTUATION_GERESH 0x05F3 is < 0");
        }
        String script = UnicodeData.getScript(aCodePoints[beforeCpIndex]);
        if (!script.equals(HEBREW_SCRIPT)) {
            throw XcodeError.IDNA_CONTEXTUAL_RULE_VIOLATION(super.getRuleName() + ": Code point before HEBREW_PUNCTUATION_GERESH 0x05F3 does not belong to the " + HEBREW_SCRIPT + " script. Offending code point is " + Integer.toHexString(aCodePoints[beforeCpIndex]).toUpperCase());
        }
    }
}

