/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.idna.contextualrule;

import com.vgrs.xcode.common.unicodedata.UnicodeData;
import com.vgrs.xcode.idna.contextualrule.AbstractAllCodePointsNotEvaluated;
import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;

public class GreekLowerNumeralSignRule
extends AbstractAllCodePointsNotEvaluated {
    private static final int GREEK_LOWER_NUMERAL_SIGN = 885;
    private static final String GREEK_SCRIPT = "Greek";

    public GreekLowerNumeralSignRule() {
        super.setCodePointToWhichRuleApplies(885);
    }

    @Override
    public void executeRule(int aCodePointIndex, int[] aCodePoints) throws XcodeException {
        int afterCpIndex = aCodePointIndex + 1;
        int length = aCodePoints.length;
        if (afterCpIndex > length - 1) {
            throw XcodeError.IDNA_CONTEXTUAL_RULE_VIOLATION(super.getRuleName() + ": Index of code point after GREEK_LOWER_NUMERAL_SIGN 0x0375 is > length of array");
        }
        String script = UnicodeData.getScript(aCodePoints[afterCpIndex]);
        if (!script.equals(GREEK_SCRIPT)) {
            throw XcodeError.IDNA_CONTEXTUAL_RULE_VIOLATION(super.getRuleName() + ": Code point after GREEK_LOWER_NUMERAL_SIGN 0x0375 does not belong to the " + GREEK_SCRIPT + " script. Offending code point is " + Integer.toHexString(aCodePoints[afterCpIndex]).toUpperCase());
        }
    }
}

