/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.idna.contextualrule;

import com.vgrs.xcode.idna.contextualrule.AbstractArabicIndicDigitsCodePoints;
import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;
import gnu.trove.set.TIntSet;

public class ExtendedArabicIndicDigitsRule
extends AbstractArabicIndicDigitsCodePoints {
    @Override
    public boolean ruleAppliesToCodepoint(int aCodePoint) {
        TIntSet extendedArabicIndicDigits = super.getExtendedArabicIndicDigits();
        return extendedArabicIndicDigits.contains(aCodePoint);
    }

    @Override
    public void executeRule(int aCodePointIndex, int[] aCodePoints) throws XcodeException {
        TIntSet arabicIndicDigits = super.getArabicIndicDigits();
        for (int codePoint : aCodePoints) {
            if (!arabicIndicDigits.contains(codePoint)) continue;
            throw XcodeError.IDNA_CONTEXTUAL_RULE_VIOLATION(super.getRuleName() + ": Arabic Indic digits exist when Extended Arabic Indic digits are present. Offending code point is " + Integer.toHexString(codePoint).toUpperCase());
        }
    }
}

