/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.idna.contextualrule;

import com.vgrs.xcode.idna.contextualrule.ContextualRule;
import com.vgrs.xcode.util.Datafile;
import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ContextualRulesRegistry {
    private static final String CONTEXTUAL_RULES_DATA = "data/idna/ContextualRules.properties";
    private static final Map<String, ContextualRule> CONTEXTUAL_RULES = new HashMap<String, ContextualRule>();
    private static boolean INITIALIZED = false;

    public static synchronized void init() throws XcodeException {
        if (INITIALIZED) {
            return;
        }
        Iterator<String> reader = null;
        reader = Datafile.getIterator(CONTEXTUAL_RULES_DATA);
        String line = null;
        while (reader.hasNext()) {
            String[] fields;
            line = reader.next();
            if (line.startsWith("#") || line.trim().isEmpty() || (fields = line.split("=")).length != 2) continue;
            String ruleName = fields[0].trim();
            String className = fields[1].trim();
            ContextualRule rule = null;
            Class<?> ruleClass = null;
            try {
                ruleClass = Class.forName(className);
                rule = (ContextualRule)ruleClass.newInstance();
                rule.setRuleName(ruleName);
                CONTEXTUAL_RULES.put(ruleName, rule);
            }
            catch (Throwable instantiationException) {
                System.err.println(instantiationException.getMessage());
                throw XcodeError.IDNSDK_INITIALIZATION_ERROR("Unable to instantiate class \"" + className + "\" specified for rule \"" + ruleName + "\": " + instantiationException.getMessage());
            }
        }
        INITIALIZED = true;
    }

    public static Set<String> runContextualRules(int[] aCodePoints) throws XcodeException {
        int length = aCodePoints.length;
        Collection<ContextualRule> contextualRules = CONTEXTUAL_RULES.values();
        HashSet<String> executedRules = new HashSet<String>();
        for (int index = 0; index < length; ++index) {
            int codePoint = aCodePoints[index];
            for (ContextualRule rule : contextualRules) {
                if (executedRules.contains(rule.getRuleName()) && rule.allCodePointsEvaluated() || !rule.ruleAppliesToCodepoint(codePoint)) continue;
                rule.executeRule(index, aCodePoints);
                executedRules.add(rule.getRuleName());
            }
        }
        if (executedRules.isEmpty()) {
            throw XcodeError.IDNA_CONTEXTUAL_RULE_VIOLATION("No contextual rules were executed even though contextual code points were present");
        }
        return executedRules;
    }

    public static void main(String[] args) {
        System.out.println(CONTEXTUAL_RULES.keySet());
    }

    static {
        try {
            ContextualRulesRegistry.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

