/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.idna.contextualrule;

import com.vgrs.xcode.idna.contextualrule.AbstractArabicIndicDigitsCodePoints;
import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;
import gnu.trove.set.TIntSet;

public class ArabicIndicDigitsRule
extends AbstractArabicIndicDigitsCodePoints {
    @Override
    public boolean ruleAppliesToCodepoint(int aCodePoint) {
        TIntSet arabicIndicDigits = super.getArabicIndicDigits();
        return arabicIndicDigits.contains(aCodePoint);
    }

    @Override
    public void executeRule(int aCodePointIndex, int[] aCodePoints) throws XcodeException {
        TIntSet extendedArabicIndicDigits = super.getExtendedArabicIndicDigits();
        for (int codePoint : aCodePoints) {
            if (!extendedArabicIndicDigits.contains(codePoint)) continue;
            throw XcodeError.IDNA_CONTEXTUAL_RULE_VIOLATION(super.getRuleName() + ": Extended Arabic Indic digits exist when Arabic Indic digits are present. Offending code point is " + Integer.toHexString(codePoint).toUpperCase());
        }
    }
}

