/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.idna;

import com.vgrs.xcode.common.Base32;
import com.vgrs.xcode.common.Unicode;
import com.vgrs.xcode.common.Utf16;
import com.vgrs.xcode.idna.Ace;
import com.vgrs.xcode.idna.Idna;
import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;

public final class Race
extends Ace {
    public static final String DEFAULT_PREFIX = "bq--";
    public static final char DOUBLE_ESCAPE = '\u0099';
    public static final byte NULL_COMPRESSION_FLAG = -40;
    public static final byte DOUBLE_F = -1;
    public static final byte DOUBLE_9 = -103;
    public static final byte ZERO = 0;
    public static final int MAX_COMPRESSION_SIZE = 36;

    public Race() {
        super(DEFAULT_PREFIX, true);
    }

    public Race(String aPrefix) {
        super(aPrefix, true);
    }

    public Race(boolean aUseStd3AsciiRules) {
        super(DEFAULT_PREFIX, aUseStd3AsciiRules);
    }

    public Race(String aPrefix, boolean aUseStd3AsciiRules) {
        super(aPrefix, aUseStd3AsciiRules);
    }

    @Override
    protected char[] internalEncode(int[] aInput) throws XcodeException {
        return Base32.encode(this.compress(Unicode.decode(aInput)));
    }

    @Override
    protected int[] internalDecode(char[] aInput) throws XcodeException {
        return Unicode.encode(this.decompress(Base32.decode(aInput)));
    }

    private byte[] compress(char[] aInput) throws XcodeException {
        byte[] output;
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        byte[] tmp = new byte[aInput.length * 2 + 1];
        byte u1 = 0;
        boolean isCompressible = true;
        for (char element : aInput) {
            byte hi = Utf16.getHighByte(element);
            if (hi == 0) continue;
            if (u1 == 0) {
                u1 = hi;
                continue;
            }
            if (hi == u1) continue;
            isCompressible = false;
            break;
        }
        int output_offset = 0;
        try {
            if (isCompressible) {
                char char_u1 = (char)(u1 & 0xFF);
                if (char_u1 >= '\u00d8' && char_u1 <= '\u00df') {
                    throw XcodeError.RACE_ENCODE_BAD_SURROGATE_USE();
                }
                tmp[output_offset++] = u1;
                for (char element : aInput) {
                    if (element == '\u0099') {
                        throw XcodeError.RACE_ENCODE_DOUBLE_ESCAPE_PRESENT();
                    }
                    if (Idna.isDelimiter(element)) {
                        throw XcodeError.RACE_DECODE_INTERNAL_DELIMITER_FOUND(" " + Integer.toString(element, 16));
                    }
                    byte u2 = Utf16.getHighByte(element);
                    byte n1 = Utf16.getLowByte(element);
                    if (u2 == u1) {
                        if (n1 != -1) {
                            tmp[output_offset++] = n1;
                            continue;
                        }
                        tmp[output_offset++] = -1;
                        tmp[output_offset++] = -103;
                        continue;
                    }
                    tmp[output_offset++] = -1;
                    tmp[output_offset++] = n1;
                }
            } else {
                tmp[output_offset++] = -40;
                for (char element : aInput) {
                    tmp[output_offset++] = Utf16.getHighByte(element);
                    tmp[output_offset++] = Utf16.getLowByte(element);
                }
            }
            if (output_offset != tmp.length) {
                output = new byte[output_offset];
                System.arraycopy(tmp, 0, output, 0, output_offset);
            } else {
                output = tmp;
            }
        }
        catch (IndexOutOfBoundsException x) {
            throw XcodeError.RACE_ENCODE_COMPRESSION_OVERFLOW();
        }
        if (output.length > 36) {
            throw XcodeError.RACE_ENCODE_COMPRESSION_OVERFLOW();
        }
        return output;
    }

    private char[] decompress(byte[] aInput) throws XcodeException {
        char[] output;
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        if (aInput.length > 36) {
            throw XcodeError.RACE_ENCODE_COMPRESSION_OVERFLOW();
        }
        char[] tmp = new char[aInput.length];
        boolean foundInvalidDnsCharacter = false;
        boolean foundUnescapedOctet = false;
        boolean foundDoubleF = false;
        boolean isCompressible = true;
        int output_offset = 0;
        try {
            if (aInput.length == 1) {
                throw XcodeError.RACE_DECODE_ODD_OCTET_COUNT();
            }
            byte u1 = aInput[0];
            if (u1 == -40) {
                if (aInput.length % 2 == 0) {
                    throw XcodeError.RACE_DECODE_ODD_OCTET_COUNT();
                }
                u1 = 0;
                for (int i = 1; i < aInput.length; i += 2) {
                    byte hi = aInput[i];
                    byte lo = aInput[i + 1];
                    char delta = (char)(hi << 8 | lo & 0xFF);
                    if (Idna.isDelimiter(delta)) {
                        throw XcodeError.RACE_DECODE_INTERNAL_DELIMITER_FOUND(" " + Integer.toString(delta, 16));
                    }
                    if (hi != 0) {
                        if (u1 == 0) {
                            u1 = hi;
                        } else if (hi != u1) {
                            isCompressible = false;
                        }
                        foundInvalidDnsCharacter = true;
                    } else if (!Utf16.isDnsCompatible(delta)) {
                        foundInvalidDnsCharacter = true;
                    }
                    tmp[output_offset++] = delta;
                }
                if (isCompressible) {
                    throw XcodeError.RACE_DECODE_IMPROPER_NULL_COMPRESSION();
                }
            } else {
                char char_u1 = (char)(u1 & 0xFF);
                if (char_u1 >= '\u00d8' && char_u1 <= '\u00df') {
                    throw XcodeError.RACE_DECODE_BAD_SURROGATE_DECOMPRESS();
                }
                for (int i = 1; i < aInput.length; ++i) {
                    char delta;
                    byte n1 = aInput[i];
                    if (!foundDoubleF) {
                        if (n1 == -1) {
                            foundDoubleF = true;
                            continue;
                        }
                        delta = (char)(u1 << 8 | n1 & 0xFF);
                        if (Idna.isDelimiter(delta)) {
                            throw XcodeError.RACE_DECODE_INTERNAL_DELIMITER_FOUND(" " + Integer.toString(delta, 16));
                        }
                        if (delta == '\u0099') {
                            throw XcodeError.RACE_DECODE_DOUBLE_ESCAPE_FOUND();
                        }
                        if (!Utf16.isDnsCompatible(delta)) {
                            foundInvalidDnsCharacter = true;
                        }
                        foundUnescapedOctet = true;
                        tmp[output_offset++] = delta;
                        continue;
                    }
                    foundDoubleF = false;
                    if (n1 == -103) {
                        delta = (char)(u1 << 8 | 0xFF);
                        foundUnescapedOctet = true;
                        foundInvalidDnsCharacter = true;
                        tmp[output_offset++] = delta;
                        continue;
                    }
                    delta = (char)(n1 & 0xFF);
                    if (u1 == 0) {
                        throw XcodeError.RACE_DECODE_UNNEEDED_ESCAPE_PRESENT();
                    }
                    if (Idna.isDelimiter(delta)) {
                        throw XcodeError.RACE_DECODE_INTERNAL_DELIMITER_FOUND(" " + Integer.toString(delta, 16));
                    }
                    if (!Utf16.isDnsCompatible(delta)) {
                        foundInvalidDnsCharacter = true;
                    }
                    tmp[output_offset++] = delta;
                }
                if (foundDoubleF) {
                    throw XcodeError.RACE_DECODE_TRAILING_ESCAPE_PRESENT();
                }
                if (u1 != 0 && !foundUnescapedOctet) {
                    throw XcodeError.RACE_DECODE_NO_UNESCAPED_OCTETS();
                }
            }
            if (!foundInvalidDnsCharacter) {
                throw XcodeError.RACE_DECODE_NO_INVALID_DNS_CHARACTERS();
            }
            if (output_offset != tmp.length) {
                output = new char[output_offset];
                System.arraycopy(tmp, 0, output, 0, output_offset);
            } else {
                output = tmp;
            }
        }
        catch (IndexOutOfBoundsException x) {
            throw XcodeError.RACE_DECODE_DECOMPRESSION_OVERFLOW();
        }
        return output;
    }
}

