/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.idna;

import com.vgrs.xcode.common.Utf16;
import com.vgrs.xcode.idna.Ace;
import com.vgrs.xcode.idna.Idna;
import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;
import gnu.trove.list.array.TIntArrayList;
import java.util.List;

public final class Punycode
extends Ace {
    public static final String DEFAULT_PREFIX = "xn--";
    private static final int BASE = 36;
    private static final int T_MIN = 1;
    private static final int T_MAX = 26;
    private static final int SKEW = 38;
    private static final int DAMP = 700;
    private static final int INITIAL_BIAS = 72;
    private static final int INITIAL_N = 128;
    private static final int DELIMITER = 45;
    private static final int MAX_INT = Integer.MAX_VALUE;
    private static final int PUNYCODE_MAX_LENGTH = 256;
    private static final int LOBASE = 35;
    private static final int CUTOFF = 455;
    private static final int MAX_UNICODE = 0x10FFFF;

    public Punycode() {
        super(DEFAULT_PREFIX, true);
    }

    public Punycode(String aPrefix) {
        super(aPrefix, true);
    }

    public Punycode(boolean aUseStd3AsciiRules) {
        super(DEFAULT_PREFIX, aUseStd3AsciiRules);
    }

    public Punycode(String aPrefix, boolean aUseStd3AsciiRules) {
        super(aPrefix, aUseStd3AsciiRules);
    }

    @Override
    protected char[] internalEncode(int[] aInput) throws XcodeException {
        return Punycode.encode(aInput, null);
    }

    @Override
    protected int[] internalDecode(char[] input) throws XcodeException {
        return Punycode.decode(input, null);
    }

    private static boolean isDelimiter(int aCodePoint) {
        return aCodePoint == 45;
    }

    private static boolean isFlagged(int aCodePoint) {
        return aCodePoint - 65 < 26;
    }

    private static int decodeDigit(char aDigit) throws XcodeException {
        if (aDigit >= '0' && aDigit <= '9') {
            return aDigit - 22;
        }
        if (aDigit >= 'A' && aDigit <= 'Z') {
            return aDigit - 65;
        }
        if (aDigit >= 'a' && aDigit <= 'z') {
            return aDigit - 97;
        }
        throw XcodeError.PUNYCODE_BAD_OUTPUT();
    }

    private static int encodeDigit(int aDigit, boolean aUcFlag) {
        int outDigit = aDigit;
        outDigit += 22;
        if (aUcFlag) {
            outDigit -= 32;
        }
        if (outDigit < 48) {
            outDigit += 75;
        }
        return outDigit;
    }

    private static int encodeBasic(int bcp, boolean ucFlag) {
        int outBcp = bcp;
        if (outBcp - 97 < 26) {
            outBcp -= 32;
        }
        if (!ucFlag && outBcp - 65 < 26) {
            outBcp += 32;
        }
        return outBcp;
    }

    private static int adapt(int aDelta, int aCodePointCount, boolean aFirstTime) {
        int outDelta = aDelta;
        outDelta = aFirstTime ? outDelta / 700 : outDelta >> 1;
        outDelta += outDelta / aCodePointCount;
        int i = 0;
        while (outDelta > 455) {
            outDelta /= 35;
            i += 36;
        }
        return i + 36 * outDelta / (outDelta + 38);
    }

    private static char[] encode(int[] aInput, List<Boolean> aUcFlags) throws XcodeException {
        int inputChar;
        int currentLargestCP = 0;
        int delta = 0;
        int cpsHandled = 0;
        int bias = 0;
        int nextLargerCP = 0;
        int currentDelta = 0;
        int currentBase = 0;
        int threshold = 0;
        int basicCPsCount = 0;
        StringBuffer encodedString = new StringBuffer();
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        currentLargestCP = 128;
        bias = 72;
        for (int i = 0; i < aInput.length; ++i) {
            inputChar = aInput[i];
            if (!Utf16.isAscii(inputChar)) continue;
            if (aUcFlags != null) {
                boolean ucFlag = aUcFlags.get(i);
                inputChar = Punycode.encodeBasic(inputChar, ucFlag);
            }
            encodedString.append((char)inputChar);
        }
        cpsHandled = basicCPsCount = encodedString.length();
        if (basicCPsCount > 0) {
            encodedString.append('-');
        }
        while (cpsHandled < aInput.length) {
            int j;
            nextLargerCP = Integer.MAX_VALUE;
            for (j = 0; j < aInput.length; ++j) {
                inputChar = aInput[j];
                if (inputChar < currentLargestCP || inputChar >= nextLargerCP) continue;
                nextLargerCP = inputChar;
            }
            if (nextLargerCP - currentLargestCP > (Integer.MAX_VALUE - delta) / (cpsHandled + 1)) {
                throw XcodeError.PUNYCODE_OVERFLOW();
            }
            delta += (nextLargerCP - currentLargestCP) * (cpsHandled + 1);
            currentLargestCP = nextLargerCP;
            for (j = 0; j < aInput.length; ++j) {
                char encodedDelta;
                boolean ucFlag;
                int outputDelta;
                inputChar = aInput[j];
                if (inputChar < currentLargestCP && ++delta == 0) {
                    throw XcodeError.PUNYCODE_BIG_OUTPUT();
                }
                if (inputChar != currentLargestCP) continue;
                currentDelta = delta;
                currentBase = 36;
                while (true) {
                    if (encodedString.length() >= 256) {
                        throw XcodeError.PUNYCODE_BIG_OUTPUT();
                    }
                    threshold = currentBase <= bias ? 1 : (currentBase >= bias + 26 ? 26 : currentBase - bias);
                    if (currentDelta < threshold) {
                        outputDelta = currentDelta;
                        ucFlag = false;
                        if (aUcFlags != null) {
                            ucFlag = aUcFlags.get(j);
                        }
                        break;
                    }
                    outputDelta = threshold + (currentDelta - threshold) % (36 - threshold);
                    ucFlag = false;
                    encodedDelta = (char)Punycode.encodeDigit(outputDelta, false);
                    encodedString.append(encodedDelta);
                    currentDelta = (currentDelta - threshold) / (36 - threshold);
                    currentBase += 36;
                }
                encodedDelta = (char)Punycode.encodeDigit(outputDelta, ucFlag);
                encodedString.append(encodedDelta);
                bias = Punycode.adapt(delta, cpsHandled + 1, cpsHandled == basicCPsCount);
                delta = 0;
                ++cpsHandled;
            }
            ++delta;
            ++currentLargestCP;
        }
        if (encodedString.length() > 256) {
            throw XcodeError.PUNYCODE_BIG_OUTPUT();
        }
        return encodedString.toString().toCharArray();
    }

    private static int[] decode(char[] aInput, List<Boolean> aUcFlags) throws XcodeException {
        char inputChar;
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        if (Punycode.isDelimiter(aInput[aInput.length - 1])) {
            throw XcodeError.PUNYCODE_DECODE_DNS_COMPATIBLE();
        }
        TIntArrayList decoded = new TIntArrayList();
        int decodedVal = 0;
        int opIndx = 0;
        int bias = 0;
        int basicCPsCount = 0;
        int j = 0;
        int indx = 0;
        int oldIndx = 0;
        int weight = 0;
        int currentBase = 0;
        int delta = 0;
        int digit = 0;
        int threshold = 0;
        decodedVal = 128;
        opIndx = 0;
        bias = 72;
        basicCPsCount = 0;
        for (j = 0; j < aInput.length; ++j) {
            inputChar = aInput[j];
            if (!Punycode.isDelimiter(inputChar)) continue;
            basicCPsCount = j;
        }
        if (basicCPsCount > 256) {
            throw XcodeError.PUNYCODE_BIG_OUTPUT();
        }
        for (j = 0; j < basicCPsCount; ++j) {
            inputChar = aInput[j];
            if (aUcFlags != null) {
                aUcFlags.add(new Boolean(Punycode.isFlagged(inputChar)));
            }
            if (!Utf16.isAscii(inputChar)) {
                throw XcodeError.PUNYCODE_BAD_OUTPUT();
            }
            decoded.add(inputChar);
        }
        indx = basicCPsCount > 0 ? basicCPsCount + 1 : 0;
        while (indx < aInput.length) {
            oldIndx = opIndx;
            weight = 1;
            currentBase = 36;
            while (true) {
                if (indx >= aInput.length) {
                    throw XcodeError.PUNYCODE_BAD_OUTPUT();
                }
                if ((digit = Punycode.decodeDigit(aInput[indx++])) >= 36) {
                    throw XcodeError.PUNYCODE_BAD_OUTPUT();
                }
                if (digit > (Integer.MAX_VALUE - opIndx) / weight) {
                    throw XcodeError.PUNYCODE_OVERFLOW();
                }
                opIndx += digit * weight;
                threshold = currentBase <= bias ? 1 : (currentBase - bias >= 26 ? 26 : currentBase - bias);
                if (digit < threshold) break;
                if (weight > Integer.MAX_VALUE / (36 - threshold)) {
                    throw XcodeError.PUNYCODE_OVERFLOW();
                }
                weight *= 36 - threshold;
                currentBase += 36;
            }
            delta = oldIndx == 0 ? opIndx / 700 : opIndx - oldIndx >>> 1;
            delta += delta / (decoded.size() + 1);
            bias = 0;
            while (delta > 455) {
                delta /= 35;
                bias += 36;
            }
            bias += 36 * delta / (delta + 38);
            if (opIndx / (decoded.size() + 1) > Integer.MAX_VALUE - decodedVal) {
                throw XcodeError.PUNYCODE_OVERFLOW();
            }
            decodedVal += opIndx / (decoded.size() + 1);
            opIndx %= decoded.size() + 1;
            if (decoded.size() >= 256) {
                throw XcodeError.PUNYCODE_BIG_OUTPUT();
            }
            if (aUcFlags != null) {
                aUcFlags.add(opIndx, new Boolean(Punycode.isFlagged(aInput[indx - 1])));
            }
            if (decodedVal > 0x10FFFF) {
                throw XcodeError.PUNYCODE_BIG_OUTPUT();
            }
            if (Idna.isDelimiter(decodedVal)) {
                throw XcodeError.PUNYCODE_DECODE_INTERNAL_DELIMITER_FOUND(" " + Integer.toString(decodedVal, 16));
            }
            decoded.insert(opIndx++, decodedVal);
        }
        return decoded.toArray();
    }
}

