/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.idna;

import com.vgrs.xcode.common.unicodedata.UnicodeData;
import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongIntMap;
import gnu.trove.set.TIntSet;

public class Normalize {
    private static TIntSet COMPATIBILITY_TABLE;
    private static TIntIntMap CANONICAL_CLASS_TABLE;
    private static TLongIntMap COMPOSE_TABLE;
    private static TIntObjectMap<int[]> DECOMPOSE_TABLE;

    private static void init() throws XcodeException {
        COMPATIBILITY_TABLE = UnicodeData.getCompatibilityTable();
        CANONICAL_CLASS_TABLE = UnicodeData.getCanonicalClassTable();
        COMPOSE_TABLE = UnicodeData.getComposeTable();
        DECOMPOSE_TABLE = UnicodeData.getDecomposeTable();
    }

    public static int[] execute(int[] aInput) throws XcodeException {
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        return Normalize.kcCompose(Normalize.kcDecompose(aInput));
    }

    private static int[] kcDecompose(int[] aInput) throws XcodeException {
        TIntArrayList output = new TIntArrayList();
        int[] buf = null;
        int charI = 0;
        int charJ = 0;
        int cClass = -1;
        int cursor = -1;
        int pCanonicalItem = 0;
        for (int element : aInput) {
            charI = element;
            if (charI == 0) {
                throw XcodeError.NORMALIZE_NULL_CHARACTER_PRESENT();
            }
            for (int element2 : buf = Normalize.doDecomposition(charI, false)) {
                charJ = element2;
                cClass = CANONICAL_CLASS_TABLE.containsKey(charJ) ? (pCanonicalItem = CANONICAL_CLASS_TABLE.get(charJ)) : 0;
                if (cClass != 0) {
                    for (cursor = output.size(); cursor > 0; --cursor) {
                        int canonicalIndex = output.get(cursor - 1);
                        if (!CANONICAL_CLASS_TABLE.containsKey(canonicalIndex)) {
                            throw XcodeError.NORMALIZE_CANONICAL_LOOKUP_ERROR();
                        }
                        pCanonicalItem = CANONICAL_CLASS_TABLE.get(canonicalIndex);
                        if (pCanonicalItem <= cClass) break;
                    }
                }
                output.insert(cursor, charJ);
            }
        }
        return output.toArray();
    }

    private static int[] doDecomposition(int aCodePoint, boolean aCanonical) {
        TIntArrayList output = new TIntArrayList();
        int[] decomposeItem = null;
        boolean compatExists = false;
        decomposeItem = DECOMPOSE_TABLE.get(aCodePoint);
        compatExists = COMPATIBILITY_TABLE.contains(aCodePoint);
        if (!(decomposeItem == null || aCanonical && compatExists)) {
            for (int element : decomposeItem) {
                output.add(Normalize.doDecomposition(element, aCanonical));
            }
        } else {
            output.add(aCodePoint);
        }
        return output.toArray();
    }

    private static int[] kcCompose(int[] output) {
        int startCh = 0;
        int pCanonical = 0;
        int pCompose = 0;
        int lastClass = -1;
        int decompPos = -1;
        int startPos = 0;
        int compPos = 1;
        int[] outputArray = new int[output.length];
        System.arraycopy(output, 0, outputArray, 0, output.length);
        startCh = outputArray[0];
        lastClass = CANONICAL_CLASS_TABLE.containsKey(startCh) ? ((pCanonical = CANONICAL_CLASS_TABLE.get(startCh)) != 0 ? 256 : 0) : 0;
        int outputArrayLength = outputArray.length;
        for (decompPos = 1; decompPos < outputArrayLength; ++decompPos) {
            int chClass = -1;
            int composite = -1;
            int ch = outputArray[decompPos];
            long pair = -1L;
            chClass = CANONICAL_CLASS_TABLE.containsKey(ch) ? (pCanonical = CANONICAL_CLASS_TABLE.get(ch)) : 0;
            pair = (long)startCh << 32 | (long)ch;
            composite = COMPOSE_TABLE.containsKey(pair) ? (pCompose = COMPOSE_TABLE.get(pair)) : -1;
            if (composite != -1 && (lastClass < chClass || lastClass == 0)) {
                outputArray[startPos] = composite;
                startCh = composite;
                continue;
            }
            if (chClass == 0) {
                startPos = compPos;
                startCh = ch;
            }
            lastClass = chClass;
            outputArray[compPos++] = ch;
        }
        if (compPos != outputArray.length) {
            int[] buf = new int[compPos];
            System.arraycopy(outputArray, 0, buf, 0, compPos);
            outputArray = buf;
        }
        return outputArray;
    }

    static {
        try {
            Normalize.init();
        }
        catch (XcodeException x) {
            throw new RuntimeException(x.getMessage());
        }
    }
}

