/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.idna;

import com.vgrs.xcode.common.UnicodeTokenizer;
import com.vgrs.xcode.common.Utf16;
import com.vgrs.xcode.common.unicodedata.UnicodeData;
import com.vgrs.xcode.idna.Ace;
import com.vgrs.xcode.idna.Bidi;
import com.vgrs.xcode.idna.Normalize;
import com.vgrs.xcode.idna.contextualrule.ContextualRulesRegistry;
import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;
import gnu.trove.list.array.TIntArrayList;
import java.util.StringTokenizer;

public final class Idna {
    public static final int[] INT_DELIMITERS = new int[]{46, 12290, 65294, 65377};
    public static final String DELIMITERS = ".\u3002\uff0e\uff61";
    public static final char ACE_DELIMITER = '.';
    public static final int MAX_DOMAIN_LABEL_LENGTH_IN_OCTETS = 63;
    public static final boolean DEFAULT_TO_UNICODE_EXCEPTION_FLAG = false;
    public static final boolean DEFAULT_REGISTRATION_PROTOCOL = true;
    private final Ace ace;
    private final boolean toUnicodeExceptionFlag;
    private final boolean isRegistrationProtocol;

    public Idna(Ace ace) throws XcodeException {
        this(ace, false, true);
    }

    public Idna(Ace ace, boolean aToUnicodeExceptionFlag) throws XcodeException {
        this(ace, aToUnicodeExceptionFlag, true);
    }

    public Idna(Ace ace, boolean aToUnicodeExceptionFlag, boolean aIsRegistrationProtocol) throws XcodeException {
        if (ace == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        this.ace = ace;
        this.toUnicodeExceptionFlag = aToUnicodeExceptionFlag;
        this.isRegistrationProtocol = aIsRegistrationProtocol;
    }

    public static boolean isDelimiter(String s) {
        return DELIMITERS.indexOf(s) >= 0;
    }

    public static boolean isDelimiter(int c) {
        return DELIMITERS.indexOf(c) >= 0;
    }

    public char[] domainToAscii(int[] input) throws XcodeException {
        if (input == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (input.length == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        StringBuilder output = new StringBuilder();
        TIntArrayList normalizedUnicode = new TIntArrayList();
        UnicodeAsciiContainer container = null;
        UnicodeTokenizer tokens = new UnicodeTokenizer(input, INT_DELIMITERS, true);
        for (int[] token : tokens) {
            if (token.length == 1 && Idna.isDelimiter(token[0])) {
                output.append('.');
                normalizedUnicode.add(token[0]);
                continue;
            }
            container = this.toAscii(token);
            output.append(container.getAscii());
            normalizedUnicode.add(container.getUnicode());
        }
        if (this.isRegistrationProtocol) {
            this.applyIdna2008BidiRules(normalizedUnicode.toArray());
        }
        return output.toString().toCharArray();
    }

    public int[] domainToUnicode(char[] input) throws XcodeException {
        if (input == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (input.length == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        TIntArrayList output = new TIntArrayList();
        StringTokenizer tokens = new StringTokenizer(new String(input), DELIMITERS, true);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (Idna.isDelimiter(token)) {
                output.add(token.charAt(0));
                continue;
            }
            output.add(this.toUnicode(token.toCharArray()));
        }
        int[] unicode = output.toArray();
        if (this.isRegistrationProtocol) {
            this.applyIdna2008BidiRules(unicode);
        }
        return unicode;
    }

    private UnicodeAsciiContainer toAscii(int[] anArray) throws XcodeException {
        UnicodeAsciiContainer container = new UnicodeAsciiContainer();
        if (this.isRegistrationProtocol) {
            int[] input = anArray;
            if (!Utf16.isAscii(input)) {
                input = Normalize.execute(input);
            }
            container.setUnicode(input);
            this.idna2008Protocol(input);
            char[] output = this.ace.encode(input);
            if (output.length > 63) {
                throw XcodeError.IDNA_LABEL_LENGTH_RESTRICTION();
            }
            container.setAscii(output);
        } else {
            container.setAscii(this.ace.encode(anArray));
            container.setUnicode(anArray);
        }
        return container;
    }

    private int[] toUnicode(char[] input) throws XcodeException {
        try {
            if (this.isRegistrationProtocol) {
                if (input.length > 63) {
                    throw XcodeError.IDNA_LABEL_LENGTH_RESTRICTION();
                }
                int[] output = this.ace.decode(input);
                this.idna2008Protocol(output);
                UnicodeData.assertNormalized(output);
                return output;
            }
            return this.ace.decode(input);
        }
        catch (XcodeException x) {
            if (this.toUnicodeExceptionFlag) {
                throw x;
            }
            return Utf16.expand(input);
        }
    }

    private void idna2008Protocol(int[] codePoints) throws XcodeException {
        if (codePoints == null || codePoints.length == 0) {
            throw XcodeError.NULL_ARGUMENT();
        }
        UnicodeData.assertNoDisallowedOrUnassignedCodePoints(codePoints);
        if (Utf16.hasHyphenRestrictions(codePoints)) {
            throw XcodeError.IDNA_IDNA_HYPHEN_RESTRICTION();
        }
        if (UnicodeData.isCombiningMark(codePoints[0])) {
            throw XcodeError.IDNA_LEADING_COMBINING_MARK();
        }
        if (UnicodeData.hasContextualCodePoints(codePoints)) {
            ContextualRulesRegistry.runContextualRules(codePoints);
        }
    }

    private void applyIdna2008BidiRules(int[] aUnicode) throws XcodeException {
        if (!Bidi.isBidiDomain(aUnicode)) {
            return;
        }
        UnicodeTokenizer tokens = new UnicodeTokenizer(aUnicode, INT_DELIMITERS, false);
        for (int[] unicodeLabel : tokens) {
            Bidi.assertCompliance(unicodeLabel);
        }
    }

    private static class UnicodeAsciiContainer {
        private int[] unicode;
        private char[] ascii;

        private UnicodeAsciiContainer() {
        }

        public int[] getUnicode() {
            return this.unicode;
        }

        public void setUnicode(int[] unicode) {
            this.unicode = unicode;
        }

        public char[] getAscii() {
            return this.ascii;
        }

        public void setAscii(char[] ascii) {
            this.ascii = ascii;
        }
    }
}

