/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.idna;

import com.vgrs.xcode.common.unicodedata.UnicodeData;
import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;
import java.util.HashSet;
import java.util.Set;

public class Bidi {
    public static final String BIDI_L = "L";
    public static final String BIDI_R = "R";
    public static final String BIDI_AL = "AL";
    public static final String BIDI_AN = "AN";
    public static final String BIDI_EN = "EN";
    public static final String BIDI_ES = "ES";
    public static final String BIDI_CS = "CS";
    public static final String BIDI_ET = "ET";
    public static final String BIDI_ON = "ON";
    public static final String BIDI_BN = "BN";
    public static final String BIDI_NSM = "NSM";
    private static final Set<String> RTL_LABEL = new HashSet<String>();
    private static final Set<String> RTL_BIDI_PROPERTIES;
    private static final Set<String> LTR_BIDI_PROPERTIES;

    public static void assertCompliance(int[] aCodePoints) throws XcodeException {
        boolean isRTLLabel = Bidi.isRTLLabel(aCodePoints);
        if (isRTLLabel) {
            Bidi.handleRTLLabel(aCodePoints);
        } else {
            Bidi.handleLTRLabel(aCodePoints);
        }
    }

    public static boolean isBidiDomain(int[] aCodePoints) {
        boolean isBidiDomain = false;
        for (int codePoint : aCodePoints) {
            String bidiClass = UnicodeData.getBidiClass(codePoint);
            if (!RTL_LABEL.contains(bidiClass)) continue;
            isBidiDomain = true;
            break;
        }
        return isBidiDomain;
    }

    private static void handleRTLLabel(int[] aCodePoints) throws XcodeException {
        boolean arabicNumberPresent = false;
        boolean europeanNumberPresent = false;
        for (int codePoint : aCodePoints) {
            String cat = UnicodeData.getBidiClass(codePoint);
            if (!RTL_BIDI_PROPERTIES.contains(cat)) {
                throw XcodeError.BIDI_RULE_2_VIOLATION();
            }
            if (cat.equals(BIDI_AN)) {
                arabicNumberPresent = true;
            }
            if (cat.equals(BIDI_EN)) {
                europeanNumberPresent = true;
            }
            if (!arabicNumberPresent || !europeanNumberPresent) continue;
            throw XcodeError.BIDI_RULE_4_VIOLATION();
        }
        boolean rtlLabelPropertyFound = false;
        for (int i = aCodePoints.length - 1; i >= 0; --i) {
            String cat = UnicodeData.getBidiClass(aCodePoints[i]);
            if (cat.equals(BIDI_NSM)) continue;
            rtlLabelPropertyFound = cat.equals(BIDI_R) || cat.equals(BIDI_AL) || cat.equals(BIDI_EN) || cat.equals(BIDI_AN);
            break;
        }
        if (!rtlLabelPropertyFound) {
            throw XcodeError.BIDI_RULE_3_VIOLATION();
        }
    }

    private static void handleLTRLabel(int[] aCodePoints) throws XcodeException {
        for (int codePoint : aCodePoints) {
            String cat = UnicodeData.getBidiClass(codePoint);
            if (LTR_BIDI_PROPERTIES.contains(cat)) continue;
            throw XcodeError.BIDI_RULE_5_VIOLATION();
        }
        boolean ltrLabelPropertyFound = false;
        for (int i = aCodePoints.length - 1; i >= 0; --i) {
            String cat = UnicodeData.getBidiClass(aCodePoints[i]);
            if (cat.equals(BIDI_NSM)) continue;
            ltrLabelPropertyFound = cat.equals(BIDI_L) || cat.equals(BIDI_EN);
            break;
        }
        if (!ltrLabelPropertyFound) {
            throw XcodeError.BIDI_RULE_6_VIOLATION();
        }
    }

    private static boolean isRTLLabel(int[] aCodePoints) throws XcodeException {
        if (aCodePoints == null || aCodePoints.length == 0) {
            throw XcodeError.NULL_ARGUMENT();
        }
        boolean isRTLLabel = true;
        String firstCpBidiCat = UnicodeData.getBidiClass(aCodePoints[0]);
        if (firstCpBidiCat.equals(BIDI_L)) {
            isRTLLabel = false;
        } else if (firstCpBidiCat.equals(BIDI_R) || firstCpBidiCat.equals(BIDI_AL)) {
            isRTLLabel = true;
        } else {
            throw XcodeError.BIDI_RULE_1_VIOLATION();
        }
        return isRTLLabel;
    }

    static {
        RTL_LABEL.add(BIDI_R);
        RTL_LABEL.add(BIDI_AL);
        RTL_LABEL.add(BIDI_AN);
        RTL_BIDI_PROPERTIES = new HashSet<String>();
        RTL_BIDI_PROPERTIES.add(BIDI_R);
        RTL_BIDI_PROPERTIES.add(BIDI_AL);
        RTL_BIDI_PROPERTIES.add(BIDI_AN);
        RTL_BIDI_PROPERTIES.add(BIDI_EN);
        RTL_BIDI_PROPERTIES.add(BIDI_ES);
        RTL_BIDI_PROPERTIES.add(BIDI_CS);
        RTL_BIDI_PROPERTIES.add(BIDI_ET);
        RTL_BIDI_PROPERTIES.add(BIDI_ON);
        RTL_BIDI_PROPERTIES.add(BIDI_BN);
        RTL_BIDI_PROPERTIES.add(BIDI_NSM);
        LTR_BIDI_PROPERTIES = new HashSet<String>();
        LTR_BIDI_PROPERTIES.add(BIDI_L);
        LTR_BIDI_PROPERTIES.add(BIDI_EN);
        LTR_BIDI_PROPERTIES.add(BIDI_ES);
        LTR_BIDI_PROPERTIES.add(BIDI_CS);
        LTR_BIDI_PROPERTIES.add(BIDI_ET);
        LTR_BIDI_PROPERTIES.add(BIDI_ON);
        LTR_BIDI_PROPERTIES.add(BIDI_BN);
        LTR_BIDI_PROPERTIES.add(BIDI_NSM);
    }
}

