/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.idna;

import com.vgrs.xcode.common.UnicodeTokenizer;
import com.vgrs.xcode.common.Utf16;
import com.vgrs.xcode.idna.Idna;
import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;
import gnu.trove.list.array.TIntArrayList;
import java.util.StringTokenizer;

public abstract class Ace {
    public static final boolean DEFAULT_USE_STD_3_ASCII_RULES = true;
    private final String prefix;
    private final boolean useStd3AsciiRules;

    public Ace(String aPrefix, boolean aUseStd3AsciiRules) {
        this.prefix = aPrefix;
        this.useStd3AsciiRules = aUseStd3AsciiRules;
    }

    public char[] domainEncode(int[] aInput) throws XcodeException {
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        StringBuilder output = new StringBuilder();
        UnicodeTokenizer tokens = new UnicodeTokenizer(aInput, Idna.INT_DELIMITERS, true);
        for (int[] token : tokens) {
            if (token.length == 1 && Idna.isDelimiter(token[0])) {
                output.append('.');
                continue;
            }
            output.append(this.encode(token));
        }
        return output.toString().toCharArray();
    }

    public int[] domainDecode(char[] aInput) throws XcodeException {
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        TIntArrayList output = new TIntArrayList();
        StringTokenizer tokens = new StringTokenizer(new String(aInput), ".\u3002\uff0e\uff61", true);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (Idna.isDelimiter(token)) {
                output.add(token.charAt(0));
                continue;
            }
            output.add(this.decode(token.toCharArray()));
        }
        return output.toArray();
    }

    public char[] encode(int[] aInput) throws XcodeException {
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        if (this.useStd3AsciiRules && !Utf16.isStd3Ascii(aInput)) {
            throw XcodeError.ACE_ENCODE_NOT_STD3ASCII();
        }
        if (Utf16.isAscii(aInput)) {
            return Utf16.contract(aInput);
        }
        if (this.hasPrefix(aInput)) {
            throw XcodeError.ACE_ENCODE_PREFIX_FOUND();
        }
        return new String(this.prefix + new String(this.internalEncode(aInput))).toCharArray();
    }

    protected abstract char[] internalEncode(int[] var1) throws XcodeException;

    public int[] decode(char[] aInput) throws XcodeException {
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        int[] output = null;
        String inputString = new String(aInput);
        if (aInput.length > this.prefix.length() && inputString.substring(0, this.prefix.length()).equalsIgnoreCase(this.prefix)) {
            char[] inputArray = inputString.substring(this.prefix.length()).toCharArray();
            output = this.internalDecode(inputArray);
        } else {
            output = Utf16.expand(aInput);
        }
        if (this.useStd3AsciiRules && !Utf16.isStd3Ascii(output)) {
            throw XcodeError.ACE_DECODE_NOT_STD3ASCII();
        }
        return output;
    }

    protected abstract int[] internalDecode(char[] var1) throws XcodeException;

    private boolean hasPrefix(int[] aInput) {
        int length = this.prefix.length();
        if (aInput.length < length) {
            return false;
        }
        int[] input32 = new int[length];
        System.arraycopy(aInput, 0, input32, 0, length);
        String input16 = new String(Utf16.contract(input32));
        return this.prefix.equalsIgnoreCase(input16);
    }
}

