/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.gui;

import com.vgrs.xcode.common.Hex;
import com.vgrs.xcode.common.Native;
import com.vgrs.xcode.common.Unicode;
import com.vgrs.xcode.common.unicodedata.UnicodeData;
import com.vgrs.xcode.ext.Convert;
import com.vgrs.xcode.gui.Animation;
import com.vgrs.xcode.idna.Idna;
import com.vgrs.xcode.idna.Punycode;
import com.vgrs.xcode.idna.Race;
import com.vgrs.xcode.idna.contextualrule.ContextualRulesRegistry;
import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class Converter
extends JFrame
implements ActionListener,
CaretListener {
    private static final long serialVersionUID = 1640196849605222530L;
    private static final String TITLE = "IDN Conversion Tool";
    private static final String DELIMITER = "\n";
    private static final Font DEFAULT_FONT = new Font("Monospaced", 0, 12);
    private static final String ICON_URL = "images/VeriSign-Small.gif";
    private static final int ANIM_WIDTH = 55;
    private static final int ANIM_HEIGHT = 23;
    private static final int ANIM_FPS = 10;
    private static final String[] ANIM_URLS = new String[]{"images/Cheetah/Cheetah-1.gif", "images/Cheetah/Cheetah-2.gif", "images/Cheetah/Cheetah-3.gif", "images/Cheetah/Cheetah-4.gif", "images/Cheetah/Cheetah-5.gif", "images/Cheetah/Cheetah-6.gif", "images/Cheetah/Cheetah-7.gif", "images/Cheetah/Cheetah-8.gif"};
    private static ClassLoader loader = Converter.class.getClassLoader();
    private final Container content;
    private JCheckBoxMenuItem useStd3AsciiRules;
    private JCheckBoxMenuItem registrationProtocol;
    private JCheckBoxMenuItem maskAceErrors;
    private ButtonGroup radioInput;
    private ButtonGroup radioOutput;
    private Animation anim;
    private final JPanel io;
    private final JTextArea input;
    private final JTextArea output;
    private final JLabel status;
    private Convert convert = null;
    private Race race;
    private Punycode punycode;
    private Idna iRace;
    private Idna iPunycode;
    private int totalRecords;
    private int errorRecords;
    private int lastLineCount = 1;
    private String lastInputText = null;

    public static void main(String[] aArgs) {
        new Converter();
    }

    public Converter() {
        super(TITLE);
        this.setDefaultCloseOperation(3);
        this.setJMenuBar(this.initMenuBar());
        this.initIdnaObjects();
        this.content = this.getContentPane();
        this.content.setLayout(new BorderLayout());
        this.io = new JPanel();
        this.io.setLayout(new BoxLayout(this.io, 0));
        this.input = new JTextArea();
        this.input.setBorder(new EtchedBorder(1));
        this.input.addCaretListener(this);
        this.output = new JTextArea();
        this.output.setBorder(new EtchedBorder(1));
        this.output.setEditable(false);
        this.io.add(this.input);
        this.io.add(this.output);
        this.content.add(new JScrollPane(this.io));
        this.status = new JLabel(this.loadIcon(ICON_URL), 2);
        this.content.add((Component)this.status, "South");
        this.initFontSupport();
        this.pack();
        this.setLocation(new Point(500, 100));
        this.setSize(800, 600);
        this.show();
    }

    private JMenuBar initMenuBar() {
        JMenuBar menubar = new JMenuBar();
        JMenu options = new JMenu("Options");
        options.setMnemonic('O');
        this.useStd3AsciiRules = new JCheckBoxMenuItem("Apply DNS Rules", true);
        this.useStd3AsciiRules.addActionListener(this);
        options.add(this.useStd3AsciiRules);
        this.registrationProtocol = new JCheckBoxMenuItem("Apply Idna Registration Protocol", true);
        this.registrationProtocol.addActionListener(this);
        options.add(this.registrationProtocol);
        this.maskAceErrors = new JCheckBoxMenuItem("Mask Ace Errors", false);
        this.maskAceErrors.addActionListener(this);
        options.add(this.maskAceErrors);
        options.addSeparator();
        JMenuItem explicit = new JMenuItem("Convert");
        explicit.addActionListener(this);
        options.add(explicit);
        menubar.add(options);
        JMenu inputtype = new JMenu("Input Type");
        this.radioInput = new ButtonGroup();
        this.initInputEncodingMenu(inputtype, this.radioInput);
        menubar.add(inputtype);
        JMenu outputtype = new JMenu("Output Type");
        this.radioOutput = new ButtonGroup();
        this.initOutputEncodingMenu(outputtype, this.radioOutput);
        menubar.add(outputtype);
        this.anim = new Animation(ANIM_URLS, 55, 23, 10);
        menubar.add(Box.createHorizontalGlue());
        menubar.add(this.anim);
        return menubar;
    }

    private void initIdnaObjects() {
        this.initAce();
        this.initIdna();
        this.initConvert();
    }

    private void initAce() {
        this.race = new Race(this.useStd3AsciiRules.getState());
        this.punycode = new Punycode(this.useStd3AsciiRules.getState());
    }

    private void initIdna() {
        try {
            this.iRace = new Idna(this.race, !this.maskAceErrors.getState(), this.registrationProtocol.getState());
            this.iPunycode = new Idna(this.punycode, !this.maskAceErrors.getState(), this.registrationProtocol.getState());
            UnicodeData.init();
            ContextualRulesRegistry.init();
        }
        catch (XcodeException x) {
            JOptionPane.showMessageDialog(this, x.getMessage(), "Unable to initialize Idna routines", 2);
        }
    }

    private void initConvert() {
        this.convert = new Convert(this.iRace, this.iPunycode);
    }

    @Override
    public void caretUpdate(CaretEvent aCaretEvent) {
        int thisLineCount = this.input.getLineCount();
        String thisInputText = this.input.getText().trim();
        if (thisLineCount != this.lastLineCount && !thisInputText.equals(this.lastInputText)) {
            this.convert();
            this.lastInputText = thisInputText;
        }
        this.lastLineCount = thisLineCount;
    }

    @Override
    public void actionPerformed(ActionEvent aActionEvent) {
        JMenuItem item;
        Object source = aActionEvent.getSource();
        if (source instanceof JCheckBoxMenuItem) {
            JCheckBoxMenuItem item2 = (JCheckBoxMenuItem)source;
            if (item2.equals(this.useStd3AsciiRules)) {
                this.initAce();
            } else if (item2.equals(this.registrationProtocol) || item2.equals(this.maskAceErrors)) {
                // empty if block
            }
            this.initIdna();
            this.initConvert();
            this.convert();
        } else if (source instanceof JRadioButtonMenuItem) {
            this.convert();
        } else if (source instanceof JMenuItem && (item = (JMenuItem)source).getText().equals("Convert")) {
            this.convert();
        }
    }

    private void convert() {
        this.output.setText("");
        this.status.setText("One moment please...");
        this.update(this.getGraphics());
        this.totalRecords = 0;
        this.errorRecords = 0;
        StringTokenizer tokens = new StringTokenizer(this.input.getText(), DELIMITER, true);
        this.output.setText("");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (token.equals(DELIMITER)) {
                this.output.append(DELIMITER);
            } else {
                this.output.append(this.convert(token));
            }
            this.anim.next();
        }
        this.status.setText("    " + this.totalRecords + " records    " + this.errorRecords + " errors");
    }

    private String convert(String aInput) {
        String output;
        String outputType;
        String input = aInput;
        if (input == null) {
            return "";
        }
        if ((input = input.trim()).length() == 0 || input.charAt(0) == '#') {
            return input;
        }
        ++this.totalRecords;
        String inputType = this.getSelection(this.radioInput);
        String originalOutputType = outputType = this.getSelection(this.radioOutput);
        try {
            if (!inputType.equals("RACE") && !inputType.equals("Punycode")) {
                if (inputType.equals("Native")) {
                    inputType = "UnicodeBigUnmarked";
                } else if (inputType.equals("UTF-32")) {
                    input = new String(Unicode.decode(Hex.decodeInts(input)));
                    inputType = "UnicodeBigUnmarked";
                } else if (inputType.equals("UTF-16")) {
                    input = new String(Hex.decodeChars(input));
                    inputType = "UnicodeBigUnmarked";
                } else {
                    byte[] b = Hex.decodeBytes(input);
                    char[] c = new char[b.length];
                    for (int i = 0; i < c.length; ++i) {
                        c[i] = (char)(b[i] & 0xFF);
                    }
                    input = new String(c);
                }
            }
            if (!outputType.equals("RACE") && !outputType.equals("Punycode")) {
                if (outputType.equals("Native")) {
                    outputType = "UnicodeBigUnmarked";
                } else if (outputType.equals("UTF-32")) {
                    outputType = "UnicodeBigUnmarked";
                } else if (outputType.equals("UTF-16")) {
                    outputType = "UnicodeBigUnmarked";
                }
            }
            if (!inputType.equals(outputType)) {
                if (inputType.equals("UnicodeBigUnmarked")) {
                    input = Converter.unpackUtf16(input);
                }
                output = this.convert.execute(input, inputType, outputType);
                if (outputType.equals("UnicodeBigUnmarked")) {
                    output = Converter.packUtf16(output);
                }
            } else {
                output = input;
            }
            if (!(originalOutputType.equals("RACE") || originalOutputType.equals("Punycode") || originalOutputType.equals("Native"))) {
                output = originalOutputType.equals("UTF-32") ? Hex.encode(Unicode.encode(output.toCharArray())) : Hex.encode(output.toCharArray());
            }
        }
        catch (XcodeException x) {
            ++this.errorRecords;
            return "Error:" + x.getCode() + " " + x.getMessage();
        }
        return output;
    }

    private String getSelection(ButtonGroup aButtonGroup) {
        Enumeration<AbstractButton> e = aButtonGroup.getElements();
        while (e.hasMoreElements()) {
            AbstractButton ab = e.nextElement();
            if (!ab.isSelected()) continue;
            return ab.getText();
        }
        return null;
    }

    public static String packUtf16(String aEncoding) throws XcodeException {
        byte[] b = Native.getEncoding(aEncoding);
        if (b.length % 2 != 0) {
            throw XcodeError.NATIVE_INVALID_ENCODING();
        }
        char[] c = new char[b.length / 2];
        for (int i = 0; i < c.length; ++i) {
            c[i] = (char)((b[i * 2] & 0xFF) << 8 | b[i * 2 + 1] & 0xFF);
        }
        return new String(c);
    }

    public static String unpackUtf16(String aUtf16String) {
        char[] a = aUtf16String.toCharArray();
        char[] b = new char[a.length * 2];
        for (int i = 0; i < a.length; ++i) {
            b[i * 2] = (char)(a[i] >> 8);
            b[i * 2 + 1] = (char)(a[i] & 0xFF);
        }
        return new String(b);
    }

    private void applyRadioButton(JMenu aJMenu, ButtonGroup aButtonGroup, String aTitle, boolean aState) {
        JRadioButtonMenuItem tmp = new JRadioButtonMenuItem(aTitle, aState);
        aJMenu.add(tmp);
        aButtonGroup.add(tmp);
        tmp.addActionListener(this);
    }

    private void initInputEncodingMenu(JMenu aJMenu, ButtonGroup aButtonGroup) {
        this.applyRadioButton(aJMenu, aButtonGroup, "RACE", false);
        this.applyRadioButton(aJMenu, aButtonGroup, "Punycode", true);
        this.applyRadioButton(aJMenu, aButtonGroup, "Native", false);
        JMenu hex = new JMenu("Hex");
        this.applyRadioButton(hex, aButtonGroup, "UTF-32", false);
        this.applyRadioButton(hex, aButtonGroup, "UTF-16", false);
        this.applyRadioButton(hex, aButtonGroup, "UTF-8", false);
        this.applyRadioButton(hex, aButtonGroup, "Big5", false);
        this.applyRadioButton(hex, aButtonGroup, "EUC_CN", false);
        this.applyRadioButton(hex, aButtonGroup, "EUC_JP", false);
        this.applyRadioButton(hex, aButtonGroup, "EUC_KR", false);
        this.applyRadioButton(hex, aButtonGroup, "EUC_TW", false);
        this.applyRadioButton(hex, aButtonGroup, "GBK", false);
        this.applyRadioButton(hex, aButtonGroup, "ISO2022JP", false);
        this.applyRadioButton(hex, aButtonGroup, "ISO2022KR", false);
        this.applyRadioButton(hex, aButtonGroup, "KOI8_R", false);
        this.applyRadioButton(hex, aButtonGroup, "SJIS", false);
        aJMenu.add(hex);
    }

    private void initOutputEncodingMenu(JMenu aJMenu, ButtonGroup aButtonGroup) {
        this.applyRadioButton(aJMenu, aButtonGroup, "RACE", false);
        this.applyRadioButton(aJMenu, aButtonGroup, "Punycode", false);
        this.applyRadioButton(aJMenu, aButtonGroup, "Native", false);
        JMenu hex = new JMenu("Hex");
        this.applyRadioButton(hex, aButtonGroup, "UTF-32", true);
        this.applyRadioButton(hex, aButtonGroup, "UTF-16", false);
        this.applyRadioButton(hex, aButtonGroup, "UTF-8", false);
        this.applyRadioButton(hex, aButtonGroup, "Big5", false);
        this.applyRadioButton(hex, aButtonGroup, "EUC_CN", false);
        this.applyRadioButton(hex, aButtonGroup, "EUC_JP", false);
        this.applyRadioButton(hex, aButtonGroup, "EUC_KR", false);
        this.applyRadioButton(hex, aButtonGroup, "EUC_TW", false);
        this.applyRadioButton(hex, aButtonGroup, "GBK", false);
        this.applyRadioButton(hex, aButtonGroup, "ISO2022JP", false);
        this.applyRadioButton(hex, aButtonGroup, "ISO2022KR", false);
        this.applyRadioButton(hex, aButtonGroup, "KOI8_R", false);
        this.applyRadioButton(hex, aButtonGroup, "SJIS", false);
        aJMenu.add(hex);
    }

    private ImageIcon loadIcon(String aResource) {
        return new ImageIcon(loader.getResource(aResource));
    }

    private void initFontSupport() {
        this.input.setFont(DEFAULT_FONT);
        this.output.setFont(DEFAULT_FONT);
    }
}

