/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import javax.swing.JLabel;

public class Animation
extends JLabel {
    private static final long serialVersionUID = -680655689678056739L;
    public static final int SCALE_TYPE = 2;
    private static ClassLoader loader = Animation.class.getClassLoader();
    private static Toolkit kit = Toolkit.getDefaultToolkit();
    private final MediaTracker tracker;
    private final Image[] images;
    private final int length;
    private final int width;
    private final int height;
    private int frame;
    private long last;
    private final int delay;
    private Image offImage;
    private Graphics offGraphics;

    public Animation(String[] aSource, int aWidth, int aHeight, int aFramesPerSecond) {
        this.width = aWidth;
        this.height = aHeight;
        this.setSize(aWidth, aHeight);
        this.setPreferredSize(new Dimension(aWidth, aHeight));
        this.length = aSource.length;
        this.images = new Image[this.length];
        this.tracker = new MediaTracker(this);
        for (int i = 0; i < this.length; ++i) {
            this.images[i] = this.loadImage(aSource[i], aWidth, aHeight);
            this.tracker.addImage(this.images[i], 0);
        }
        this.frame = 0;
        this.last = 0L;
        this.delay = aFramesPerSecond > 0 ? 1000 / aFramesPerSecond : 100;
        this.offImage = null;
        this.offGraphics = null;
    }

    public void next() {
        long click = System.currentTimeMillis();
        if (click - this.last > (long)this.delay) {
            ++this.frame;
            this.paint(this.getGraphics());
            this.last = click;
        }
    }

    @Override
    public void paint(Graphics aGraphics) {
        this.update(aGraphics);
    }

    @Override
    public void update(Graphics aGraphics) {
        Dimension d = this.getSize();
        if (this.offGraphics == null || d.width != this.width || d.height != this.height) {
            this.setSize(this.width, this.height);
            this.offImage = this.createImage(this.width, this.height);
            this.offGraphics = this.offImage.getGraphics();
        }
        this.offGraphics.setColor(this.getBackground());
        this.offGraphics.fillRect(0, 0, this.width, this.height);
        this.offGraphics.setColor(Color.black);
        this.paintFrame(this.offGraphics);
        aGraphics.drawImage(this.offImage, 0, 0, null);
    }

    public void paintFrame(Graphics aGraphics) {
        if (this.tracker.statusID(0, true) == 8) {
            aGraphics.drawImage(this.images[this.frame % this.length], 0, 0, null);
        }
    }

    private Image loadImage(String aImageResource, int aWidth, int aHeight) {
        Image image = kit.getImage(loader.getResource(aImageResource));
        if (image == null) {
            image = kit.getImage(aImageResource);
        }
        if (image == null) {
            return image;
        }
        return image.getScaledInstance(aWidth, aHeight, 2);
    }
}

