/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.ext;

import com.vgrs.xcode.common.Native;
import com.vgrs.xcode.common.Unicode;
import com.vgrs.xcode.ext.DCE;
import com.vgrs.xcode.idna.Ace;
import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;
import java.util.Iterator;
import java.util.Set;

public class EncodingVariants {
    private Ace ace = null;

    public EncodingVariants(Ace ace) {
        this.ace = ace;
    }

    public String[] execute(String input, String[] encodings) throws XcodeException {
        if (input == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (input.length() == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        String tld = "";
        int lastDotIndex = input.lastIndexOf(46);
        if (lastDotIndex != -1) {
            tld = input.substring(lastDotIndex).toLowerCase();
            input = input.substring(0, lastDotIndex);
        }
        String utf16 = new String(Unicode.decode(this.ace.decode(input.toCharArray())));
        Set<String> variants = null;
        variants = encodings == null ? Native.encodeToSet(utf16) : Native.encodeToSet(utf16, encodings);
        Iterator<String> iterator = variants.iterator();
        String[] results = new String[variants.size()];
        int i = 0;
        while (iterator.hasNext()) {
            byte[] variant = Native.getEncoding(iterator.next());
            results[i++] = new String(DCE.encode(variant)) + tld;
        }
        return results;
    }
}

