/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.ext;

import com.vgrs.xcode.common.Base32;
import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;

public final class DCE {
    public static final int MAX_TOKEN_SIZE = 63;
    public static final char DELIMITER = '.';

    public static char[] encode(byte[] input) throws XcodeException {
        if (input == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (input.length == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        char[] dnsCompatibleBytes = null;
        char[] base32 = Base32.encode(input);
        if (base32.length > 63) {
            int delimsToInsert = base32.length / 63;
            dnsCompatibleBytes = new char[base32.length + delimsToInsert];
            System.arraycopy(base32, 0, dnsCompatibleBytes, 0, 63);
            for (int i = 1; i <= delimsToInsert; ++i) {
                int bytesToCopy = 63;
                if (base32.length < (i + 1) * 63) {
                    bytesToCopy = base32.length - i * 63;
                }
                dnsCompatibleBytes[i * 64 - 1] = 46;
                System.arraycopy(base32, i * 63, dnsCompatibleBytes, i * 64, bytesToCopy);
            }
        } else {
            dnsCompatibleBytes = base32;
        }
        return dnsCompatibleBytes;
    }

    public static byte[] decode(char[] input) throws XcodeException {
        if (input == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (input.length == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        char[] base32 = null;
        if (input.length > 63) {
            int delimsToRemove = input.length / 64;
            base32 = new char[input.length - delimsToRemove];
            System.arraycopy(input, 0, base32, 0, 63);
            for (int i = 1; i <= delimsToRemove; ++i) {
                if (input[i * 64 - 1] != '.') {
                    throw XcodeError.DCE_INVALID_DELIMITER();
                }
                int bytesToCopy = 63;
                if (input.length < (i + 1) * 64) {
                    bytesToCopy = input.length - i * 64;
                }
                System.arraycopy(input, i * 64, base32, i * 63, bytesToCopy);
            }
        } else {
            base32 = input;
        }
        return Base32.decode(base32);
    }
}

