/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.ext;

import com.vgrs.xcode.common.Native;
import com.vgrs.xcode.common.Unicode;
import com.vgrs.xcode.common.UnicodeFilter;
import com.vgrs.xcode.idna.Idna;
import com.vgrs.xcode.idna.Punycode;
import com.vgrs.xcode.idna.Race;
import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;
import java.util.Properties;

public class Convert {
    public static final String RACE_ENCODING = "RACE";
    public static final String PUNYCODE_ENCODING = "PUNYCODE";
    private Idna iRace = null;
    private Idna iPunycode = null;
    private UnicodeFilter unicodeFilter = null;

    public Convert() throws XcodeException {
        this(new Idna(new Race()), new Idna(new Punycode()), null);
    }

    public Convert(Punycode aPunycode, Race aRace) throws XcodeException {
        this(new Idna(aRace), new Idna(aPunycode), null);
    }

    public Convert(Punycode aPunycode, Race aRace, boolean aToUnicodeExceptionFlag) throws XcodeException {
        this(new Idna(aRace, aToUnicodeExceptionFlag), new Idna(aPunycode, aToUnicodeExceptionFlag), null);
    }

    public Convert(Punycode aPunycode, Race aRace, boolean aToUnicodeExceptionFlag, boolean aIsRegistrationProtocol) throws XcodeException {
        this(new Idna(aRace, aToUnicodeExceptionFlag, aIsRegistrationProtocol), new Idna(aPunycode, aToUnicodeExceptionFlag, aIsRegistrationProtocol), null);
    }

    public Convert(Idna aRace, Idna aPunycode, UnicodeFilter aUnicodeFilter) {
        this.iRace = aRace;
        this.iPunycode = aPunycode;
        this.unicodeFilter = aUnicodeFilter;
    }

    public Convert(Idna aRace, Idna aPunycode) {
        this.iRace = aRace;
        this.iPunycode = aPunycode;
    }

    public String execute(String aInput, String aInputType, String aOutputType) throws XcodeException {
        if (aInput == null || aInputType == null || aOutputType == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length() == 0 || aInputType.length() == 0 || aOutputType.length() == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        int[] unicode = this.decode(aInput, aInputType);
        if (this.unicodeFilter != null) {
            this.unicodeFilter.assertNone(unicode);
        }
        return this.encode(unicode, aOutputType);
    }

    public Properties execute(String aInput, String aInputType, String[] aOutputTypes) throws XcodeException {
        if (aInput == null || aInputType == null || aOutputTypes == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length() == 0 || aInputType.length() == 0 || aOutputTypes.length == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        int[] unicode = this.decode(aInput, aInputType);
        if (this.unicodeFilter != null) {
            this.unicodeFilter.assertNone(unicode);
        }
        return this.encode(unicode, aOutputTypes);
    }

    private int[] decode(String aInput, String aInputType) throws XcodeException {
        if (aInputType.equalsIgnoreCase(RACE_ENCODING)) {
            return this.iRace.domainToUnicode(aInput.toCharArray());
        }
        if (aInputType.equalsIgnoreCase(PUNYCODE_ENCODING)) {
            return this.iPunycode.domainToUnicode(aInput.toCharArray());
        }
        String utf16 = Native.decode(Native.getEncoding(aInput), aInputType);
        return Unicode.encode(utf16.toCharArray());
    }

    private String encode(int[] aUnicodeCodePoints, String aOutputType) throws XcodeException {
        if (aOutputType.equalsIgnoreCase(RACE_ENCODING)) {
            return new String(this.iRace.domainToAscii(aUnicodeCodePoints));
        }
        if (aOutputType.equalsIgnoreCase(PUNYCODE_ENCODING)) {
            return new String(this.iPunycode.domainToAscii(aUnicodeCodePoints));
        }
        return Native.encode(new String(Unicode.decode(aUnicodeCodePoints)), aOutputType);
    }

    private Properties encode(int[] aUnicodeCodePoints, String[] aOutputTypes) {
        Properties results = new Properties();
        for (String aOutputType : aOutputTypes) {
            try {
                results.put(aOutputType, this.encode(aUnicodeCodePoints, aOutputType));
            }
            catch (XcodeException x) {
                // empty catch block
            }
        }
        return results;
    }
}

