/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.common.unicodedata;

import com.vgrs.xcode.common.Hex;
import com.vgrs.xcode.common.Unicode;
import com.vgrs.xcode.common.unicodedata.UnicodeDataFileUtil;
import com.vgrs.xcode.util.Datafile;
import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongIntHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Iterator;

public final class UnicodeDataLoader {
    private static TIntSet UNICODE_DATA_POINTS = new TIntHashSet();
    private static final TIntSet EXCLUDED_TABLE = new TIntHashSet();
    private static final TIntSet COMPATIBILITY_TABLE = new TIntHashSet();
    private static final TIntIntMap CANONICAL_CLASS_TABLE = new TIntIntHashMap();
    private static final TLongIntMap COMPOSE_TABLE = new TLongIntHashMap();
    private static final TIntObjectMap<int[]> DECOMPOSE_TABLE = new TIntObjectHashMap<int[]>();
    private static final TIntObjectMap<String> GENERAL_CATEGORY_TABLE = new TIntObjectHashMap<String>();
    private static final TIntObjectMap<String> BIDI_CLASS_TABLE = new TIntObjectHashMap<String>();

    private static void init() throws XcodeException {
        UnicodeDataLoader.loadExclusionChars();
        UnicodeDataLoader.loadUnicodeData();
        UnicodeDataLoader.loadHangulDecompositions();
    }

    private static void loadExclusionChars() throws XcodeException {
        UnicodeDataFileUtil.loadCodePointSet("data/unicode/CompositionExclusions.txt.gz", EXCLUDED_TABLE, " #\t");
    }

    private static void loadUnicodeData() throws XcodeException {
        Iterator<String> reader = null;
        String line = null;
        String token = null;
        String codePoint = null;
        int[] mapseq = null;
        int unicodeChar = -1;
        int canonicalClass = -1;
        int semicolonIndx = -1;
        int nextSemicolonIndx = -1;
        int gtIndex = -1;
        int first = 0;
        int second = 0;
        long pair = -1L;
        try {
            reader = Datafile.getIterator("data/unicode/UnicodeData.txt.gz");
            while (reader.hasNext()) {
                boolean fCompat = false;
                line = reader.next();
                if (line != null) {
                    if (line.length() == 0 || line.charAt(0) == '#' || (semicolonIndx = line.indexOf(59)) == -1) continue;
                    if (semicolonIndx != 0) {
                        codePoint = line.substring(0, semicolonIndx);
                        if (UnicodeDataLoader.isEmpty(codePoint)) continue;
                        unicodeChar = Integer.parseInt(codePoint, 16);
                        UNICODE_DATA_POINTS.add(unicodeChar);
                    }
                    if ((nextSemicolonIndx = line.indexOf(59, semicolonIndx + 1)) == -1) continue;
                    if (nextSemicolonIndx - semicolonIndx > 1 && !UnicodeDataLoader.isEmpty(token = line.substring(semicolonIndx + 1, nextSemicolonIndx)) && token.indexOf(", First") != -1) {
                        UnicodeDataLoader.handleUnicodeDataRanges(line, reader);
                    }
                    if ((nextSemicolonIndx = line.indexOf(59, (semicolonIndx = nextSemicolonIndx) + 1)) == -1) continue;
                    if (nextSemicolonIndx - semicolonIndx > 1 && !UnicodeDataLoader.isEmpty(token = line.substring(semicolonIndx + 1, nextSemicolonIndx))) {
                        GENERAL_CATEGORY_TABLE.put(unicodeChar, token);
                    }
                    if ((nextSemicolonIndx = line.indexOf(59, (semicolonIndx = nextSemicolonIndx) + 1)) == -1) continue;
                    if (nextSemicolonIndx - semicolonIndx > 1 && !UnicodeDataLoader.isEmpty(token = line.substring(semicolonIndx + 1, nextSemicolonIndx))) {
                        canonicalClass = Integer.parseInt(token);
                        if (canonicalClass != (canonicalClass & 0xFF)) {
                            throw XcodeError.NORMALIZE_BAD_CANONICALCLASS_ERROR();
                        }
                        CANONICAL_CLASS_TABLE.put(unicodeChar, canonicalClass);
                    }
                    if ((nextSemicolonIndx = line.indexOf(59, (semicolonIndx = nextSemicolonIndx) + 1)) == -1) continue;
                    if (nextSemicolonIndx - semicolonIndx > 1 && !UnicodeDataLoader.isEmpty(token = line.substring(semicolonIndx + 1, nextSemicolonIndx))) {
                        BIDI_CLASS_TABLE.put(unicodeChar, token);
                    }
                    if ((nextSemicolonIndx = line.indexOf(59, (semicolonIndx = nextSemicolonIndx) + 1)) == -1 || nextSemicolonIndx - semicolonIndx <= 1) continue;
                    token = line.substring(semicolonIndx + 1, nextSemicolonIndx);
                    if (token.charAt(0) == '<') {
                        COMPATIBILITY_TABLE.add(unicodeChar);
                        gtIndex = token.indexOf(62);
                        if (gtIndex == -1) {
                            throw XcodeError.NORMALIZE_BAD_COMPATTAG_ERROR();
                        }
                        token = token.substring(gtIndex + 2);
                        fCompat = true;
                    }
                    if ((mapseq = Hex.decodeInts(token)).length < 1 || mapseq.length > 2 && !fCompat) {
                        throw XcodeError.NORMALIZE_BAD_DECOMPSEQUENCE_ERROR();
                    }
                    DECOMPOSE_TABLE.put(unicodeChar, mapseq);
                    if (fCompat || EXCLUDED_TABLE.contains(unicodeChar)) continue;
                    if (mapseq.length > 1) {
                        first = mapseq[0];
                        second = mapseq[1];
                    } else {
                        first = 0;
                        second = mapseq[0];
                    }
                    pair = (long)first << 32 | (long)second;
                    COMPOSE_TABLE.put(pair, unicodeChar);
                    continue;
                }
                break;
            }
        }
        catch (NumberFormatException x) {
            line = ": \"" + line + "\"";
            throw XcodeError.INVALID_FILE_FORMAT(line);
        }
        catch (Exception x) {
            line = ": \"" + line + "\"";
            throw XcodeError.INVALID_FILE_FORMAT(line);
        }
    }

    private static void handleUnicodeDataRanges(String aFirstTokenRangeLine, Iterator<String> aReader) throws XcodeException {
        String line = null;
        String token = null;
        String codePoint = null;
        String codePointLast = null;
        int[] mapseq = null;
        int unicodeChar = -1;
        int canonicalClass = -1;
        int semicolonIndx = -1;
        int semicolonIndxLast = -1;
        int nextSemicolonIndx = -1;
        int gtIndex = -1;
        int first = 0;
        int second = 0;
        long pair = -1L;
        boolean fCompat = false;
        int[] input_decoded = null;
        String lastTokenRangeLine = null;
        if (aReader.hasNext()) {
            lastTokenRangeLine = aReader.next();
        }
        if (lastTokenRangeLine.indexOf(", Last") == -1) {
            return;
        }
        line = aFirstTokenRangeLine;
        semicolonIndx = line.indexOf(59);
        if (semicolonIndx == -1) {
            return;
        }
        if (semicolonIndx != 0) {
            codePoint = line.substring(0, semicolonIndx);
            if (UnicodeDataLoader.isEmpty(codePoint)) {
                return;
            }
            semicolonIndxLast = lastTokenRangeLine.indexOf(59);
            if (semicolonIndxLast == -1) {
                return;
            }
            if (semicolonIndxLast != 0) {
                codePointLast = lastTokenRangeLine.substring(0, semicolonIndxLast);
                String input = codePoint + " " + codePointLast;
                try {
                    input_decoded = Hex.decodeInts(input);
                }
                catch (XcodeException x) {
                    input_decoded = Unicode.encode(input.toCharArray());
                }
            }
            if (input_decoded.length > 1) {
                for (void j = input_decoded[0]; j <= input_decoded[1]; ++j) {
                    UNICODE_DATA_POINTS.add((int)j);
                }
            }
        }
        if ((nextSemicolonIndx = line.indexOf(59, semicolonIndx + 1)) == -1) {
            return;
        }
        semicolonIndx = nextSemicolonIndx;
        if ((nextSemicolonIndx = line.indexOf(59, semicolonIndx + 1)) == -1) {
            return;
        }
        if (nextSemicolonIndx - semicolonIndx > 1 && !UnicodeDataLoader.isEmpty(token = line.substring(semicolonIndx + 1, nextSemicolonIndx)) && input_decoded.length > 1) {
            for (int j = input_decoded[0]; j <= input_decoded[1]; ++j) {
                GENERAL_CATEGORY_TABLE.put(j, token);
            }
        }
        if ((nextSemicolonIndx = line.indexOf(59, (semicolonIndx = nextSemicolonIndx) + 1)) == -1) {
            return;
        }
        if (nextSemicolonIndx - semicolonIndx > 1 && !UnicodeDataLoader.isEmpty(token = line.substring(semicolonIndx + 1, nextSemicolonIndx))) {
            canonicalClass = Integer.parseInt(token);
            if (canonicalClass != (canonicalClass & 0xFF)) {
                throw XcodeError.NORMALIZE_BAD_CANONICALCLASS_ERROR();
            }
            if (input_decoded.length > 1) {
                for (int j = input_decoded[0]; j <= input_decoded[1]; ++j) {
                    CANONICAL_CLASS_TABLE.put(j, canonicalClass);
                }
            }
        }
        if ((nextSemicolonIndx = line.indexOf(59, (semicolonIndx = nextSemicolonIndx) + 1)) == -1) {
            return;
        }
        if (nextSemicolonIndx - semicolonIndx > 1 && !UnicodeDataLoader.isEmpty(token = line.substring(semicolonIndx + 1, nextSemicolonIndx)) && input_decoded.length > 1) {
            for (int j = input_decoded[0]; j <= input_decoded[1]; ++j) {
                BIDI_CLASS_TABLE.put(j, token);
            }
        }
        if ((nextSemicolonIndx = line.indexOf(59, (semicolonIndx = nextSemicolonIndx) + 1)) == -1) {
            return;
        }
        if (nextSemicolonIndx - semicolonIndx > 1) {
            token = line.substring(semicolonIndx + 1, nextSemicolonIndx);
            if (token.charAt(0) == '<') {
                if (input_decoded.length > 1) {
                    for (int j = input_decoded[0]; j <= input_decoded[1]; ++j) {
                        COMPATIBILITY_TABLE.add(j);
                    }
                }
                if ((gtIndex = token.indexOf(62)) == -1) {
                    throw XcodeError.NORMALIZE_BAD_COMPATTAG_ERROR();
                }
                token = token.substring(gtIndex + 2);
                fCompat = true;
            }
            if ((mapseq = Hex.decodeInts(token)).length < 1 || mapseq.length > 2 && !fCompat) {
                throw XcodeError.NORMALIZE_BAD_DECOMPSEQUENCE_ERROR();
            }
            if (input_decoded.length > 1) {
                for (int j = input_decoded[0]; j <= input_decoded[1]; ++j) {
                    DECOMPOSE_TABLE.put(j, mapseq);
                }
            }
            if (!fCompat && !EXCLUDED_TABLE.contains(-1)) {
                if (mapseq.length > 1) {
                    first = mapseq[0];
                    second = mapseq[1];
                } else {
                    first = 0;
                    second = mapseq[0];
                }
                pair = (long)first << 32 | (long)second;
                if (input_decoded.length > 1) {
                    for (int j = input_decoded[0]; j <= input_decoded[1]; ++j) {
                        COMPOSE_TABLE.put(pair, j);
                    }
                }
            }
        }
    }

    private static void loadHangulDecompositions() {
        int[] mapseq = null;
        int unicodeChar = -1;
        int first = 0;
        int second = 0;
        long pair = -1L;
        int sIndex = -1;
        int tIndex = -1;
        int nCount = -1;
        int sCount = -1;
        nCount = 588;
        sCount = 19 * nCount;
        for (sIndex = 0; sIndex < sCount; ++sIndex) {
            tIndex = sIndex % 28;
            if (tIndex != 0) {
                first = 44032 + sIndex - tIndex;
                second = 4519 + tIndex;
            } else {
                first = 4352 + sIndex / nCount;
                second = 4449 + sIndex % nCount / 28;
            }
            mapseq = new int[]{first, second};
            pair = (long)first << 32 | (long)second;
            unicodeChar = sIndex + 44032;
            DECOMPOSE_TABLE.put(unicodeChar, mapseq);
            COMPOSE_TABLE.put(pair, unicodeChar);
        }
    }

    private static boolean isEmpty(String aToken) {
        return null == aToken || aToken.trim().isEmpty();
    }

    protected static TIntSet getUnicodeDataPoints() {
        return UNICODE_DATA_POINTS;
    }

    protected static TIntSet getExcludedTable() {
        return EXCLUDED_TABLE;
    }

    protected static TIntSet getCompatibilityTable() {
        return COMPATIBILITY_TABLE;
    }

    protected static TIntIntMap getCanonicalClassTable() {
        return CANONICAL_CLASS_TABLE;
    }

    protected static TLongIntMap getComposeTable() {
        return COMPOSE_TABLE;
    }

    protected static TIntObjectMap<int[]> getDecomposeTable() {
        return DECOMPOSE_TABLE;
    }

    protected static TIntObjectMap<String> getGeneralCategoryTable() {
        return GENERAL_CATEGORY_TABLE;
    }

    protected static TIntObjectMap<String> getBidiClassTable() {
        return BIDI_CLASS_TABLE;
    }

    protected static void nullifyUnicodeDataPointsTable() {
        UNICODE_DATA_POINTS = null;
    }

    static {
        try {
            UnicodeDataLoader.init();
        }
        catch (XcodeException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

