/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.common.unicodedata;

import com.vgrs.xcode.common.Hex;
import com.vgrs.xcode.common.Range;
import com.vgrs.xcode.util.Datafile;
import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;
import gnu.trove.map.TIntCharMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.set.TIntSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class UnicodeDataFileUtil {
    public static void loadCodePointAndCategoryMap(String aFileName, TIntObjectMap<String> aMap, String aDelimiter, Set<String> aPropertiesToLoad) throws XcodeException {
        if (aPropertiesToLoad == null || aPropertiesToLoad.isEmpty()) {
            return;
        }
        Iterator<String> reader = null;
        String line = null;
        String token = null;
        try {
            reader = Datafile.getIterator(aFileName);
            StringTokenizer st = null;
            String property = null;
            while (reader.hasNext()) {
                line = reader.next().trim();
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                st = new StringTokenizer(line, aDelimiter);
                token = st.nextToken().trim().replace("..", " ");
                property = st.nextToken().trim();
                if (!aPropertiesToLoad.contains(property)) continue;
                int[] codePoints = Hex.decodeInts(token);
                if (codePoints.length > 1) {
                    for (int i = codePoints[0]; i <= codePoints[1]; ++i) {
                        aMap.put(i, property);
                    }
                    continue;
                }
                aMap.put(codePoints[0], property);
            }
        }
        catch (Throwable x) {
            UnicodeDataFileUtil.handleException(x, line);
        }
    }

    public static void loadCodePointAndCategorySet(String aFileName, TIntObjectMap<Set<String>> aMap, String[] delimiters) throws XcodeException {
        Iterator<String> reader = null;
        String line = null;
        String codePointsToken = null;
        String propertyToken = null;
        try {
            reader = Datafile.getIterator(aFileName);
            StringTokenizer st = null;
            String property = null;
            while (reader.hasNext()) {
                line = reader.next().trim();
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                st = new StringTokenizer(line, delimiters[0]);
                codePointsToken = st.nextToken();
                codePointsToken = codePointsToken.trim();
                propertyToken = st.nextToken();
                propertyToken = propertyToken.trim();
                st = new StringTokenizer(propertyToken, delimiters[1]);
                property = st.nextToken();
                property = property.trim();
                int[] codePoints = Hex.decodeInts(codePointsToken = codePointsToken.replace("..", " "));
                if (codePoints.length > 1) {
                    for (int j = codePoints[0]; j <= codePoints[1]; ++j) {
                        Set<String> set = aMap.get(j);
                        if (set == null) {
                            set = new HashSet<String>();
                        }
                        set.add(property);
                        aMap.put(j, set);
                    }
                    continue;
                }
                Set<String> set = aMap.get(codePoints[0]);
                if (set == null) {
                    set = new HashSet<String>();
                }
                set.add(property);
                aMap.put(codePoints[0], set);
            }
        }
        catch (Throwable x) {
            UnicodeDataFileUtil.handleException(x, line);
        }
    }

    public static void loadCodePointAndCategoryMap(String aFileName, TIntObjectMap<String> aMap, String[] delimiters, Set<String> aPropertiesToLoad) throws XcodeException {
        Iterator<String> reader = null;
        String line = null;
        String codePointToken = null;
        String propertyToken = null;
        try {
            reader = Datafile.getIterator(aFileName);
            StringTokenizer st = null;
            String property = null;
            while (reader.hasNext()) {
                line = reader.next().trim();
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                st = new StringTokenizer(line, delimiters[0]);
                codePointToken = st.nextToken().trim().replace("..", " ");
                propertyToken = st.nextToken().trim();
                st = new StringTokenizer(propertyToken, delimiters[1]);
                property = st.nextToken().trim();
                if (aPropertiesToLoad != null && !aPropertiesToLoad.contains(property)) continue;
                int[] codePoints = Hex.decodeInts(codePointToken);
                if (codePoints.length > 1) {
                    for (int j = codePoints[0]; j <= codePoints[1]; ++j) {
                        aMap.put(j, property);
                    }
                    continue;
                }
                aMap.put(codePoints[0], property);
            }
        }
        catch (Throwable x) {
            UnicodeDataFileUtil.handleException(x, line);
        }
    }

    public static void loadCodePointAndCategoryCharMap(String aFileName, TIntCharMap aMap, String[] delimiters, Set<String> aPropertiesToLoad) throws XcodeException {
        Iterator<String> reader = null;
        String line = null;
        String codePointsToken = null;
        String propertyToken = null;
        try {
            reader = Datafile.getIterator(aFileName);
            StringTokenizer st = null;
            String property = null;
            while (reader.hasNext()) {
                line = reader.next().trim();
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                st = new StringTokenizer(line, delimiters[0]);
                codePointsToken = st.nextToken().trim().replace("..", " ");
                propertyToken = st.nextToken().trim();
                st = new StringTokenizer(propertyToken, delimiters[1]);
                property = st.nextToken().trim();
                if (aPropertiesToLoad != null && !aPropertiesToLoad.contains(property)) continue;
                int[] codePoints = Hex.decodeInts(codePointsToken);
                if (codePoints.length > 1) {
                    for (int j = codePoints[0]; j <= codePoints[1]; ++j) {
                        aMap.put(j, property.toCharArray()[0]);
                    }
                    continue;
                }
                aMap.put(codePoints[0], property.toCharArray()[0]);
            }
        }
        catch (Throwable x) {
            UnicodeDataFileUtil.handleException(x, line);
        }
    }

    public static void loadCodePointSet(String aFileName, TIntSet aSet, String aDelimiter) throws XcodeException {
        Iterator<String> reader = null;
        String line = null;
        StringTokenizer st = null;
        String token = null;
        int codePoint = -1;
        try {
            reader = Datafile.getIterator(aFileName);
            while (reader.hasNext()) {
                line = reader.next().trim();
                if (line.isEmpty() || line.charAt(0) == '#' || !(st = new StringTokenizer(line, aDelimiter)).hasMoreTokens()) continue;
                token = st.nextToken();
                codePoint = Integer.parseInt(token, 16);
                aSet.add(codePoint);
            }
        }
        catch (Throwable x) {
            UnicodeDataFileUtil.handleException(x, line);
        }
    }

    public static List<Range> getRanges(String resource) throws XcodeException {
        ArrayList<Range> out = new ArrayList<Range>();
        Iterator<String> reader = null;
        String line = null;
        StringTokenizer st = null;
        reader = Datafile.getIterator(resource);
        try {
            while (reader.hasNext() && (line = reader.next()) != null) {
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#' || !(st = new StringTokenizer(line, " \t-;")).hasMoreTokens()) continue;
                int first = Integer.parseInt(st.nextToken(), 16);
                int last = st.hasMoreTokens() ? Integer.parseInt(st.nextToken(), 16) : first;
                out.add(new Range(first, last));
            }
        }
        catch (NumberFormatException x) {
            line = ": \"" + line + "\"";
            throw XcodeError.INVALID_FILE_FORMAT(line);
        }
        catch (Exception x) {
            line = ": \"" + line + "\"";
            throw XcodeError.INVALID_FILE_FORMAT(line);
        }
        return out;
    }

    private static void handleException(Throwable aException, String line) throws XcodeException {
        String formattedLine = ": \"" + line + "\"";
        throw XcodeError.INVALID_FILE_FORMAT(aException.getMessage() + formattedLine);
    }
}

