/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.common.unicodedata;

import com.vgrs.xcode.common.Range;
import com.vgrs.xcode.common.UnicodeFilter;
import com.vgrs.xcode.common.unicodedata.DerivedNormalizationProperties;
import com.vgrs.xcode.common.unicodedata.ExceptionCodePoints;
import com.vgrs.xcode.common.unicodedata.UnicodeCodePointCategory;
import com.vgrs.xcode.common.unicodedata.UnicodeDataConstants;
import com.vgrs.xcode.common.unicodedata.UnicodeDataFileUtil;
import com.vgrs.xcode.common.unicodedata.UnicodeDataLoader;
import com.vgrs.xcode.idna.Normalize;
import com.vgrs.xcode.util.RangeCreator;
import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntCharMap;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongIntMap;
import gnu.trove.map.hash.TIntCharHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class UnicodeData {
    private static TIntSet UNICODE_DATA_POINTS;
    private static final TIntSet CONTEXTUAL_CODE_POINTS;
    private static TIntObjectMap<Set<String>> PROP_LIST_TABLE;
    private static TIntObjectMap<Set<String>> DERIVED_CORE_PROP_TABLE;
    private static TIntObjectMap<Set<String>> DERIVED_NORMALIZATION_PROP_TABLE;
    private static TIntObjectMap<String> BLOCKS_TABLE;
    private static TIntObjectMap<String> HANGUL_SYLLABLE_TYPE_TABLE;
    private static final TIntObjectMap<String> SCRIPTS_TABLE;
    private static final TIntCharMap DERIVED_JOINING_TYPE_TABLE;
    private static TIntObjectMap<String> BIDI_CLASS_TABLE;
    private static TIntObjectMap<String> GENERAL_CATEGORY_TABLE;
    private static TIntSet COMPATIBILITY_TABLE;
    private static TIntIntMap CANONICAL_CLASS_TABLE;
    private static TLongIntMap COMPOSE_TABLE;
    private static TIntObjectMap<int[]> DECOMPOSE_TABLE;
    private static UnicodeFilter DISALLOWED_AND_UNASSIGNED_FILTER;
    private static final TIntSet LETTERS_DIGITS_HYPHEN;
    private static final TIntSet COMBINING_MARK;
    private static final TIntSet BACKWARD_COMPATIBLE_CODE_POINTS;
    private static boolean INITIALIZED;

    public static synchronized void init() throws XcodeException {
        if (!INITIALIZED) {
            try {
                UnicodeData.buildLookupTables();
            }
            catch (Throwable ex) {
                throw XcodeError.IDNSDK_INITIALIZATION_ERROR(ex.getMessage());
            }
        }
        INITIALIZED = true;
    }

    public static boolean isCombiningMark(int aCodePoint) {
        return COMBINING_MARK.contains(aCodePoint);
    }

    public static String getScript(int aCodePoint) {
        String script = SCRIPTS_TABLE.get(aCodePoint);
        if (script != null) {
            return script;
        }
        return "Unknown";
    }

    public static String getBidiClass(int aCodePoint) {
        String bidiClass = BIDI_CLASS_TABLE.get(aCodePoint);
        if (bidiClass == null) {
            return "L";
        }
        return bidiClass;
    }

    public static char getJoiningType(int aCodePoint) {
        char joiningType = 'U';
        if (DERIVED_JOINING_TYPE_TABLE.containsKey(aCodePoint)) {
            joiningType = DERIVED_JOINING_TYPE_TABLE.get(aCodePoint);
        }
        return joiningType;
    }

    public static void assertNoDisallowedOrUnassignedCodePoints(int[] aCodePoints) throws XcodeException {
        DISALLOWED_AND_UNASSIGNED_FILTER.assertNone(aCodePoints);
    }

    public static boolean isDisallowedOrUnassignedCodePoint(int aCodePoint) {
        return DISALLOWED_AND_UNASSIGNED_FILTER.has(aCodePoint);
    }

    public static boolean isNormalized(int[] aCodePoints) {
        try {
            Normalize.execute(aCodePoints);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static void assertNormalized(int[] aCodePoints) throws XcodeException {
        int[] normalizedCodePoints = Normalize.execute(aCodePoints);
        if (!Arrays.equals(normalizedCodePoints, aCodePoints)) {
            throw XcodeError.NORMALIZE_NOT_IN_NFC_FORM();
        }
    }

    public static int isNormalizationNeeded(int[] aCodePoints) {
        for (int codePoint : aCodePoints) {
            Set<String> value = DERIVED_NORMALIZATION_PROP_TABLE.get(codePoint);
            if (value != null && value.contains("NFC_QC_N")) {
                return 0;
            }
            if (value == null || !value.contains("NFC_QC_M")) continue;
            return 2;
        }
        return 1;
    }

    public static int getCanonicalClass(int aCodePoint) {
        if (CANONICAL_CLASS_TABLE.containsKey(aCodePoint)) {
            return CANONICAL_CLASS_TABLE.get(aCodePoint);
        }
        return 0;
    }

    public static boolean hasContextualCodePoints(int[] aCodePoints) {
        for (int codePoint : aCodePoints) {
            if (!CONTEXTUAL_CODE_POINTS.contains(codePoint)) continue;
            return true;
        }
        return false;
    }

    public static UnicodeCodePointCategory getCodePointDerivedProperty(int aCodePoint) {
        if (aCodePoint == 8204 || aCodePoint == 8205) {
            return UnicodeCodePointCategory.CONTEXTJ;
        }
        if (CONTEXTUAL_CODE_POINTS.contains(aCodePoint)) {
            return UnicodeCodePointCategory.CONTEXTO;
        }
        if (DISALLOWED_AND_UNASSIGNED_FILTER.has(aCodePoint)) {
            return UnicodeCodePointCategory.DISALLOWED;
        }
        return UnicodeCodePointCategory.PVALID;
    }

    private static UnicodeCodePointCategory internalGetCodePointDerivedProperty(int aCodePoint) {
        try {
            if (UnicodeData.inExceptions(aCodePoint)) {
                return UnicodeData.exceptions(aCodePoint);
            }
            if (UnicodeData.inBackwardCompatible(aCodePoint)) {
                return UnicodeData.backwardCompatible(aCodePoint);
            }
            if (UnicodeData.inUnassigned(aCodePoint)) {
                return UnicodeCodePointCategory.UNASSIGNED;
            }
            if (UnicodeData.inLDH(aCodePoint)) {
                return UnicodeCodePointCategory.PVALID;
            }
            if (UnicodeData.inJoinControl(aCodePoint)) {
                return UnicodeCodePointCategory.CONTEXTJ;
            }
            if (UnicodeData.inUnstable(aCodePoint)) {
                return UnicodeCodePointCategory.DISALLOWED;
            }
            if (UnicodeData.inIgnorableProperties(aCodePoint)) {
                return UnicodeCodePointCategory.DISALLOWED;
            }
            if (UnicodeData.inIgnorableBlocks(aCodePoint)) {
                return UnicodeCodePointCategory.DISALLOWED;
            }
            if (UnicodeData.inOldHangulJamo(aCodePoint)) {
                return UnicodeCodePointCategory.DISALLOWED;
            }
            if (UnicodeData.inLetterDigits(aCodePoint)) {
                return UnicodeCodePointCategory.PVALID;
            }
            return UnicodeCodePointCategory.DISALLOWED;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static UnicodeCodePointCategory backwardCompatible(int aCodePoint) {
        return UnicodeCodePointCategory.DISALLOWED;
    }

    private static UnicodeCodePointCategory exceptions(int aCodePoint) {
        UnicodeCodePointCategory category = ExceptionCodePoints.getCategory(aCodePoint);
        return category;
    }

    private static boolean inExceptions(int aCodePoint) {
        return ExceptionCodePoints.getCategory(aCodePoint) != null;
    }

    private static boolean inBackwardCompatible(int aCodePoint) {
        return BACKWARD_COMPATIBLE_CODE_POINTS.contains(aCodePoint);
    }

    private static boolean inUnassigned(int aCodePoint) {
        boolean nonCharacterCodePoint = false;
        Set<String> set = PROP_LIST_TABLE.get(aCodePoint);
        if (set != null && set.contains("Noncharacter_Code_Point")) {
            nonCharacterCodePoint = true;
        }
        return !UNICODE_DATA_POINTS.contains(aCodePoint) && !nonCharacterCodePoint;
    }

    private static boolean inLDH(int aCodePoint) {
        return LETTERS_DIGITS_HYPHEN.contains(aCodePoint);
    }

    private static void loadLDH() {
        int i;
        LETTERS_DIGITS_HYPHEN.add(45);
        for (i = 48; i <= 57; ++i) {
            LETTERS_DIGITS_HYPHEN.add(i);
        }
        for (i = 97; i <= 122; ++i) {
            LETTERS_DIGITS_HYPHEN.add(i);
        }
    }

    private static boolean inJoinControl(int aCodePoint) {
        Set<String> set = PROP_LIST_TABLE.get(aCodePoint);
        return set != null && set.contains("Join_Control");
    }

    private static boolean inUnstable(int aCodePoint) {
        Set<String> value = DERIVED_NORMALIZATION_PROP_TABLE.get(aCodePoint);
        return value != null && (value.contains("NFKC_QC_N") || value.contains("NFKC_CF"));
    }

    private static boolean inIgnorableProperties(int aCodePoint) {
        Set<String> value = null;
        value = DERIVED_CORE_PROP_TABLE.get(aCodePoint);
        if (value != null && value.contains("Default_Ignorable_Code_Point")) {
            return true;
        }
        value = PROP_LIST_TABLE.get(aCodePoint);
        return value != null && (value.contains("White_Space") || value.contains("Noncharacter_Code_Point"));
    }

    private static boolean inIgnorableBlocks(int aCodePoint) {
        return BLOCKS_TABLE.containsKey(aCodePoint);
    }

    private static boolean inOldHangulJamo(int aCodePoint) {
        return HANGUL_SYLLABLE_TYPE_TABLE.containsKey(aCodePoint);
    }

    private static boolean inLetterDigits(int aCodePoint) {
        String propertyValue = GENERAL_CATEGORY_TABLE.get(aCodePoint);
        return propertyValue != null && (propertyValue.equals("Ll") || propertyValue.equals("Lu") || propertyValue.equals("Lo") || propertyValue.equals("Nd") || propertyValue.equals("Lm") || propertyValue.equals("Mn") || propertyValue.equals("Mc"));
    }

    private static void buildLookupTables() throws XcodeException {
        UnicodeData.initializeUnicodeDataVariables();
        UnicodeData.loadLDH();
        UnicodeData.loadPropListData();
        UnicodeData.loadDerivedNormalizationPropertiesData();
        UnicodeData.loadBlocksData();
        UnicodeData.loadHangulSyllableTypeData();
        UnicodeData.loadDerivedJoiningTypeData();
        UnicodeData.loadScriptsData();
        UnicodeData.loadDerivedNormalizationPropertiesData();
        UnicodeData.loadDerivedCorePropertiesData();
        UnicodeData.collapseUnicodeData();
    }

    private static void initializeUnicodeDataVariables() {
        UNICODE_DATA_POINTS = UnicodeDataLoader.getUnicodeDataPoints();
        BIDI_CLASS_TABLE = UnicodeDataLoader.getBidiClassTable();
        CANONICAL_CLASS_TABLE = UnicodeDataLoader.getCanonicalClassTable();
        COMPATIBILITY_TABLE = UnicodeDataLoader.getCompatibilityTable();
        COMPOSE_TABLE = UnicodeDataLoader.getComposeTable();
        DECOMPOSE_TABLE = UnicodeDataLoader.getDecomposeTable();
        GENERAL_CATEGORY_TABLE = UnicodeDataLoader.getGeneralCategoryTable();
    }

    private static void collapseUnicodeData() throws XcodeException {
        TIntArrayList disallowedAndUnassignedPoints = new TIntArrayList();
        UnicodeCodePointCategory category = null;
        String property = null;
        for (int unicodeCodePoint = 0; unicodeCodePoint <= 0x10FFFF; ++unicodeCodePoint) {
            category = UnicodeData.internalGetCodePointDerivedProperty(unicodeCodePoint);
            switch (category) {
                case PVALID: {
                    break;
                }
                case CONTEXTO: {
                    CONTEXTUAL_CODE_POINTS.add(unicodeCodePoint);
                    break;
                }
                case CONTEXTJ: {
                    CONTEXTUAL_CODE_POINTS.add(unicodeCodePoint);
                    break;
                }
                default: {
                    disallowedAndUnassignedPoints.add(unicodeCodePoint);
                }
            }
            property = GENERAL_CATEGORY_TABLE.get(unicodeCodePoint);
            if (property == null || !property.equals("Me") && !property.equals("Mc") && !property.equals("Mn")) continue;
            COMBINING_MARK.add(unicodeCodePoint);
        }
        Collection<Range> prohibitedRanges = RangeCreator.createRanges(disallowedAndUnassignedPoints);
        DISALLOWED_AND_UNASSIGNED_FILTER.add(prohibitedRanges);
        UnicodeDataLoader.nullifyUnicodeDataPointsTable();
        UNICODE_DATA_POINTS = null;
        BLOCKS_TABLE = null;
        HANGUL_SYLLABLE_TYPE_TABLE = null;
        DERIVED_CORE_PROP_TABLE = null;
        PROP_LIST_TABLE = null;
    }

    private static void loadHangulSyllableTypeData() throws XcodeException {
        HashSet<String> hangulJamoType = new HashSet<String>();
        hangulJamoType.add("L");
        hangulJamoType.add("V");
        hangulJamoType.add("T");
        UnicodeDataFileUtil.loadCodePointAndCategoryMap("data/unicode/HangulSyllableType.txt.gz", HANGUL_SYLLABLE_TYPE_TABLE, UnicodeDataConstants.SEMI_COLON_TAB_DELIMITERS, hangulJamoType);
    }

    private static void loadBlocksData() throws XcodeException {
        HashSet<String> blocksToload = new HashSet<String>();
        blocksToload.add("Combining Diacritical Marks for Symbols");
        blocksToload.add("Musical Symbols");
        blocksToload.add("Ancient Greek Musical Notation");
        UnicodeDataFileUtil.loadCodePointAndCategoryMap("data/unicode/Blocks.txt.gz", BLOCKS_TABLE, ";", blocksToload);
    }

    private static void loadScriptsData() throws XcodeException {
        UnicodeDataFileUtil.loadCodePointAndCategoryMap("data/unicode/Scripts.txt.gz", SCRIPTS_TABLE, UnicodeDataConstants.SEMI_COLON_TAB_DELIMITERS, null);
    }

    private static void loadDerivedJoiningTypeData() throws XcodeException {
        UnicodeDataFileUtil.loadCodePointAndCategoryCharMap("data/unicode/DerivedJoiningType.txt.gz", DERIVED_JOINING_TYPE_TABLE, UnicodeDataConstants.SEMI_COLON_TAB_DELIMITERS, null);
    }

    private static void loadDerivedNormalizationPropertiesData() throws XcodeException {
        DERIVED_NORMALIZATION_PROP_TABLE = DerivedNormalizationProperties.getDerivedNormalizationPropTable();
    }

    private static void loadDerivedCorePropertiesData() throws XcodeException {
        UnicodeDataFileUtil.loadCodePointAndCategorySet("data/unicode/DerivedCoreProperties.txt.gz", DERIVED_CORE_PROP_TABLE, UnicodeDataConstants.SEMI_COLON_TAB_DELIMITERS);
    }

    private static void loadPropListData() throws XcodeException {
        UnicodeDataFileUtil.loadCodePointAndCategorySet("data/unicode/PropList.txt.gz", PROP_LIST_TABLE, UnicodeDataConstants.SEMI_COLON_TAB_DELIMITERS);
    }

    public static final int getCanonicalCombiningClass(int aCodePoint) {
        return CANONICAL_CLASS_TABLE.get(aCodePoint);
    }

    public static final TIntSet getCompatibilityTable() {
        if (!INITIALIZED) {
            throw new IllegalStateException("UnicodeData has not initialized properly.");
        }
        return COMPATIBILITY_TABLE;
    }

    public static final TIntIntMap getCanonicalClassTable() {
        if (!INITIALIZED) {
            throw new IllegalStateException("UnicodeData has not initialized properly.");
        }
        return CANONICAL_CLASS_TABLE;
    }

    public static final TLongIntMap getComposeTable() {
        if (!INITIALIZED) {
            throw new IllegalStateException("UnicodeData has not initialized properly.");
        }
        return COMPOSE_TABLE;
    }

    public static final TIntObjectMap<int[]> getDecomposeTable() {
        if (!INITIALIZED) {
            throw new IllegalStateException("UnicodeData has not initialized properly.");
        }
        return DECOMPOSE_TABLE;
    }

    public static final String getGeneralCategory(int aCodePoint) {
        if (!INITIALIZED) {
            throw new IllegalStateException("UnicodeData has not initialized properly.");
        }
        return GENERAL_CATEGORY_TABLE.get(aCodePoint);
    }

    public static TIntSet getContextualCodePointsTable() {
        if (!INITIALIZED) {
            throw new IllegalStateException("UnicodeData has not initialized properly.");
        }
        return new TIntHashSet(CONTEXTUAL_CODE_POINTS);
    }

    public static TIntObjectMap<String> getScriptsTable() {
        if (!INITIALIZED) {
            throw new IllegalStateException("UnicodeData has not initialized properly.");
        }
        TIntObjectHashMap<String> scriptsTable = new TIntObjectHashMap<String>(SCRIPTS_TABLE);
        return scriptsTable;
    }

    public static TIntCharMap getDerivedJoiningTypeTable() {
        if (!INITIALIZED) {
            throw new IllegalStateException("UnicodeData has not initialized properly.");
        }
        TIntCharHashMap derivedJoiningType = new TIntCharHashMap(DERIVED_JOINING_TYPE_TABLE);
        return derivedJoiningType;
    }

    public static TIntObjectMap<String> getBidiClassTable() {
        if (!INITIALIZED) {
            throw new IllegalStateException("UnicodeData has not initialized properly.");
        }
        TIntObjectHashMap<String> bidiClassTable = new TIntObjectHashMap<String>(BIDI_CLASS_TABLE);
        return bidiClassTable;
    }

    public static TIntObjectMap<String> getGeneralCategoryTable() {
        if (!INITIALIZED) {
            throw new IllegalStateException("UnicodeData has not initialized properly.");
        }
        TIntObjectHashMap<String> generalCategoryTable = new TIntObjectHashMap<String>(GENERAL_CATEGORY_TABLE);
        return generalCategoryTable;
    }

    public static TIntSet getCombiningMarkTable() {
        if (!INITIALIZED) {
            throw new IllegalStateException("UnicodeData has not initialized properly.");
        }
        return new TIntHashSet(COMBINING_MARK);
    }

    static {
        CONTEXTUAL_CODE_POINTS = new TIntHashSet();
        PROP_LIST_TABLE = new TIntObjectHashMap<Set<String>>();
        DERIVED_CORE_PROP_TABLE = new TIntObjectHashMap<Set<String>>();
        DERIVED_NORMALIZATION_PROP_TABLE = null;
        BLOCKS_TABLE = new TIntObjectHashMap<String>();
        HANGUL_SYLLABLE_TYPE_TABLE = new TIntObjectHashMap<String>();
        SCRIPTS_TABLE = new TIntObjectHashMap<String>();
        DERIVED_JOINING_TYPE_TABLE = new TIntCharHashMap();
        DISALLOWED_AND_UNASSIGNED_FILTER = new UnicodeFilter("Disallowed/Unassigned");
        LETTERS_DIGITS_HYPHEN = new TIntHashSet();
        COMBINING_MARK = new TIntHashSet();
        BACKWARD_COMPATIBLE_CODE_POINTS = new TIntHashSet();
        INITIALIZED = false;
        try {
            UnicodeData.init();
        }
        catch (XcodeException x) {
            throw new RuntimeException(x.getMessage());
        }
    }
}

