/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.common.unicodedata;

import com.vgrs.xcode.common.Hex;
import com.vgrs.xcode.util.Datafile;
import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class DerivedNormalizationProperties {
    private static final TIntObjectMap<Set<String>> DERIVED_NORMALIZATION_PROP_TABLE = new TIntObjectHashMap<Set<String>>();

    public static TIntObjectMap<Set<String>> getDerivedNormalizationPropTable() {
        return DERIVED_NORMALIZATION_PROP_TABLE;
    }

    private static void init() throws XcodeException {
        Iterator<String> reader = null;
        String line = null;
        String codePointString = null;
        String nfcProperty = null;
        String derivedNormalizationProperty = null;
        StringTokenizer st = null;
        String property = null;
        try {
            reader = Datafile.getIterator("data/unicode/DerivedNormalizationProps.txt.gz");
            while (reader.hasNext() && (line = reader.next()) != null) {
                int end;
                int start;
                int[] codePoints;
                if (line.length() == 0 || line.charAt(0) == '#') continue;
                property = null;
                st = new StringTokenizer(line, ";");
                if (st.hasMoreTokens()) {
                    codePointString = st.nextToken().trim();
                }
                if (st.hasMoreTokens()) {
                    nfcProperty = st.nextToken().trim();
                }
                if (!nfcProperty.equals("NFKC_QC") && !nfcProperty.equals("NFC_QC") && !nfcProperty.equals("NFKC_CF")) continue;
                if (st.hasMoreTokens()) {
                    derivedNormalizationProperty = st.nextToken().trim();
                }
                if ((st = new StringTokenizer(derivedNormalizationProperty, " #\t")).hasMoreTokens()) {
                    property = st.nextToken();
                    property = property.trim();
                }
                if ((codePoints = Hex.decodeInts(codePointString = codePointString.replace("..", " "))).length == 2) {
                    start = codePoints[0];
                    end = codePoints[1];
                } else if (codePoints.length == 1) {
                    end = start = codePoints[0];
                } else {
                    line = ": \"" + line + "\"";
                    throw XcodeError.INVALID_FILE_FORMAT(line);
                }
                for (int codePoint = start; codePoint <= end; ++codePoint) {
                    Set<String> set = DERIVED_NORMALIZATION_PROP_TABLE.get(codePoint);
                    if (set == null) {
                        set = new HashSet<String>();
                    }
                    if (property != null && (property.equals("N") || property.equals("M"))) {
                        set.add(nfcProperty + "_" + property);
                    } else {
                        set.add(nfcProperty);
                    }
                    DERIVED_NORMALIZATION_PROP_TABLE.put(codePoint, set);
                }
            }
        }
        catch (NumberFormatException x) {
            line = ": \"" + line + "\"";
            throw XcodeError.INVALID_FILE_FORMAT(line);
        }
        catch (Exception x) {
            line = ": \"" + line + "\"";
            throw XcodeError.INVALID_FILE_FORMAT(line);
        }
    }

    static {
        try {
            DerivedNormalizationProperties.init();
        }
        catch (XcodeException x) {
            throw new RuntimeException(x.getMessage());
        }
    }
}

