/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.common;

public class Utf16 {
    public static final char HYPHEN = '-';

    public static byte[] contract(char[] aInput) {
        byte[] output = new byte[aInput.length];
        for (int i = 0; i < aInput.length; ++i) {
            output[i] = (byte)(aInput[i] & 0xFF);
        }
        return output;
    }

    public static char[] contract(int[] aInput) {
        char[] output = new char[aInput.length];
        for (int i = 0; i < aInput.length; ++i) {
            output[i] = (char)(aInput[i] & 0xFFFF);
        }
        return output;
    }

    public static char[] expand(byte[] aInput) {
        char[] output = new char[aInput.length];
        for (int i = 0; i < aInput.length; ++i) {
            output[i] = (char)(aInput[i] & 0xFF);
        }
        return output;
    }

    public static int[] expand(char[] aInput) {
        int[] output = new int[aInput.length];
        for (int i = 0; i < aInput.length; ++i) {
            output[i] = aInput[i];
        }
        return output;
    }

    public static byte getHighByte(char aInput) {
        return (byte)(aInput >> 8);
    }

    public static byte getLowByte(char aInput) {
        return (byte)aInput;
    }

    public static boolean isAscii(char aChar) {
        return '\u0000' <= aChar && aChar < '\u0080';
    }

    public static boolean isAscii(char[] aCharArray) {
        int length = aCharArray.length;
        for (int i = 0; i < length; ++i) {
            if (Utf16.isAscii(aCharArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isAscii(int aCodePoint) {
        return 0 <= aCodePoint && aCodePoint < 128;
    }

    public static boolean isAscii(int[] aCodePoints) {
        int length = aCodePoints.length;
        for (int i = 0; i < length; ++i) {
            if (Utf16.isAscii(aCodePoints[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isDnsCompatible(char aChar) {
        return aChar == '-' || aChar >= '0' && aChar <= '9' || aChar >= 'A' && aChar <= 'Z' || aChar >= 'a' && aChar <= 'z';
    }

    public static boolean isDnsCompatible(char[] aCharArray) {
        int length = aCharArray.length;
        if (length <= 0) {
            return true;
        }
        if (aCharArray[0] == '-' || aCharArray[length - 1] == '-') {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (Utf16.isDnsCompatible(aCharArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isDnsCompatible(int aCodePoint) {
        return aCodePoint == 45 || aCodePoint >= 48 && aCodePoint <= 57 || aCodePoint >= 65 && aCodePoint <= 90 || aCodePoint >= 97 && aCodePoint <= 122;
    }

    public static boolean isDnsCompatible(int[] aCodePoints) {
        int length = aCodePoints.length;
        if (length <= 0) {
            return true;
        }
        if (aCodePoints[0] == 45 || aCodePoints[length - 1] == 45) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (Utf16.isDnsCompatible(aCodePoints[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isHighSurrogate(char aInput) {
        return aInput >= '\ud800' && aInput < '\udc00';
    }

    public static boolean isLowSurrogate(char aInput) {
        return aInput >= '\udc00' && aInput < '\ue000';
    }

    public static boolean isNative(char aChar) {
        return '\u0000' <= aChar && aChar < '\u0100';
    }

    public static boolean isNative(char[] aCharArray) {
        int length = aCharArray.length;
        for (int i = 0; i < length; ++i) {
            if (Utf16.isNative(aCharArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrintable(char aChar) {
        return aChar > '\u001f' && aChar < '\u007f' || aChar > '\u00a0' && aChar < '\u0100';
    }

    public static boolean isPrintable(char[] aCharArray) {
        for (int i = 0; i < aCharArray.length; ++i) {
            if (Utf16.isPrintable(aCharArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrintable(int aCodePoint) {
        return aCodePoint > 31 && aCodePoint < 127 || aCodePoint > 160 && aCodePoint < 256;
    }

    public static boolean isPrintable(int[] aCodePoints) {
        for (int i = 0; i < aCodePoints.length; ++i) {
            if (Utf16.isPrintable(aCodePoints[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isStd3Ascii(char[] aCharArray) {
        if (aCharArray.length <= 0) {
            return true;
        }
        if (aCharArray[0] == '-' || aCharArray[aCharArray.length - 1] == '-') {
            return false;
        }
        for (int i = 0; i < aCharArray.length; ++i) {
            if (!Utf16.isAscii(aCharArray[i]) || Utf16.isDnsCompatible(aCharArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isStd3Ascii(int[] aCodePoints) {
        if (aCodePoints.length <= 0) {
            return true;
        }
        if (aCodePoints[0] == 45 || aCodePoints[aCodePoints.length - 1] == 45) {
            return false;
        }
        for (int i = 0; i < aCodePoints.length; ++i) {
            if (!Utf16.isAscii(aCodePoints[i]) || Utf16.isDnsCompatible(aCodePoints[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean hasHyphenRestrictions(int[] aCodePoints) {
        if (aCodePoints.length <= 0) {
            return false;
        }
        if (aCodePoints[0] == 45 || aCodePoints[aCodePoints.length - 1] == 45) {
            return true;
        }
        return aCodePoints.length > 3 && aCodePoints[2] == 45 && aCodePoints[3] == 45;
    }

    public static boolean isSurrogate(char aInput) {
        return Utf16.isHighSurrogate(aInput) || Utf16.isLowSurrogate(aInput);
    }
}

