/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class UnicodeTokenizer
implements Iterable<int[]> {
    private final Collection<int[]> results = new ArrayList<int[]>();

    public UnicodeTokenizer(int[] aInput, int[] aDelimiters, boolean aReturnDelims) {
        int[] token;
        int len = 0;
        for (int i = 0; i < aInput.length; ++i) {
            if (UnicodeTokenizer.exists(aInput[i], aDelimiters)) {
                if (len > 0) {
                    token = new int[len];
                    System.arraycopy(aInput, i - len, token, 0, len);
                    this.results.add(token);
                }
                if (aReturnDelims) {
                    token = new int[]{aInput[i]};
                    this.results.add(token);
                }
                len = 0;
                continue;
            }
            ++len;
        }
        if (len > 0) {
            token = new int[len];
            System.arraycopy(aInput, aInput.length - len, token, 0, len);
            this.results.add(token);
        }
    }

    private static boolean exists(int aCodePoint, int[] aDelimiters) {
        for (int delimiter : aDelimiters) {
            if (delimiter != aCodePoint) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<int[]> iterator() {
        return this.results.iterator();
    }
}

