/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.common;

import com.vgrs.xcode.common.Range;

public class UnicodeMatrix {
    private static final int LENGTH = 4096;
    private final int floor;
    private final int ceiling;
    private char[] data = null;

    public UnicodeMatrix(int aPlane) {
        this.floor = aPlane * 65536;
        this.ceiling = this.floor + 65535;
        this.data = new char[4096];
    }

    public void insert(int[] aRange) {
        this.insert(aRange[0], aRange[1]);
    }

    public void insert(Range aRange) {
        this.insert(aRange.first, aRange.last);
    }

    public void insert(int aFirst, int aLast) {
        int first = aFirst;
        int last = aLast;
        if (last < this.floor || first > this.ceiling) {
            return;
        }
        first = first < this.floor ? 0 : (first &= 0xFFFF);
        last = last > this.ceiling ? 65535 : (last &= 0xFFFF);
        for (int i = first; i <= last; ++i) {
            this.insert(i);
        }
    }

    public void insert(int aCodePoint) {
        int n = aCodePoint >> 4;
        this.data[n] = (char)(this.data[n] | 1 << (aCodePoint & 0xF));
    }

    public boolean spans(int[] aRange) {
        return aRange[0] >= this.floor && aRange[1] <= this.ceiling;
    }

    public boolean spans(Range aRange) {
        return aRange.first >= this.floor && aRange.last <= this.ceiling;
    }

    public boolean spans(int aFirst, int aLast) {
        return aFirst >= this.floor && aLast <= this.ceiling;
    }

    public boolean test(int aInput) {
        return (1 << (aInput & 0xF) & this.data[(aInput & 0xFFF0) >> 4]) > 0;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < this.data.length; ++i) {
            out.append(Integer.toString(this.data[i], 16) + ", ");
            if (i % 8 != 7) continue;
            out.append('\n');
        }
        return out.toString();
    }
}

