/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.common;

import com.vgrs.xcode.common.Filter;
import com.vgrs.xcode.common.Range;
import com.vgrs.xcode.common.Unicode;
import com.vgrs.xcode.common.UnicodeMatrix;
import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;

public class UnicodeFilter
implements Filter {
    public static final int RANGE_THRESHOLD = 30;
    public static final int UNICODE_PLANES = 17;
    private TreeSet<Range> ranges = null;
    private final int[] rangeCount = new int[17];
    private final UnicodeMatrix[] matrix = new UnicodeMatrix[17];
    private String prefix = " ";

    public UnicodeFilter() {
        this.ranges = new TreeSet();
        for (int i = 0; i < 17; ++i) {
            this.rangeCount[i] = 0;
        }
    }

    public UnicodeFilter(String aPrefix) {
        this();
        this.setPrefix(aPrefix);
    }

    @Override
    public void add(Collection<Range> aRanges) throws XcodeException {
        for (Range range : aRanges) {
            Unicode.assertValid(range);
            int firstPlane = UnicodeFilter.getPlane(range.first);
            int lastPlane = UnicodeFilter.getPlane(range.last);
            int i = firstPlane;
            while (i <= lastPlane) {
                int n = i++;
                this.rangeCount[n] = this.rangeCount[n] + 1;
            }
        }
        this.ranges.addAll(aRanges);
        this.compile();
    }

    @Override
    public void add(int aPoint) throws XcodeException {
        int plane;
        Unicode.isValid(aPoint);
        int n = plane = UnicodeFilter.getPlane(aPoint);
        this.rangeCount[n] = this.rangeCount[n] + 1;
        this.ranges.add(new Range(aPoint, aPoint));
        this.compile();
    }

    @Override
    public void add(Range aRange) throws XcodeException {
        Unicode.assertValid(aRange);
        int firstPlane = UnicodeFilter.getPlane(aRange.first);
        int lastPlane = UnicodeFilter.getPlane(aRange.last);
        int i = firstPlane;
        while (i <= lastPlane) {
            int n = i++;
            this.rangeCount[n] = this.rangeCount[n] + 1;
        }
        this.ranges.add(aRange);
        this.compile();
    }

    @Override
    public void add(Range[] aRanges) throws XcodeException {
        for (Range range : aRanges) {
            Unicode.assertValid(range);
            int firstPlane = UnicodeFilter.getPlane(range.first);
            int lastPlane = UnicodeFilter.getPlane(range.last);
            int i = firstPlane;
            while (i <= lastPlane) {
                int n = i++;
                this.rangeCount[n] = this.rangeCount[n] + 1;
            }
            this.ranges.add(range);
        }
        this.compile();
    }

    @Override
    public void assertAll(int[] aPoints) throws XcodeException {
        for (int point : aPoints) {
            if (this.has(point)) continue;
            this.throwUnicodeFilterDoesNotPass(point);
        }
    }

    @Override
    public void assertNone(int[] aPoints) throws XcodeException {
        for (int point : aPoints) {
            if (!this.has(point)) continue;
            this.throwUnicodeFilterDoesNotPass(point);
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean has(int aPoint) {
        if (!Unicode.isValid(aPoint)) {
            return false;
        }
        int plane = UnicodeFilter.getPlane(aPoint);
        if (this.hasMatrix(plane)) {
            return this.matrix[plane].test(aPoint);
        }
        Range match = this.ranges.floor(new Range(aPoint));
        return match != null && match.has(aPoint);
    }

    @Override
    public boolean hasAll(int[] aPoints) {
        for (int point : aPoints) {
            if (this.has(point)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasNone(int[] aPoints) {
        for (int point : aPoints) {
            if (!this.has(point)) continue;
            return false;
        }
        return true;
    }

    public void setPrefix(String aPrefix) {
        this.prefix = aPrefix == null ? "" : aPrefix;
    }

    public String toFullString() {
        StringBuilder out = new StringBuilder();
        for (int plane = 0; plane < 17; ++plane) {
            if (!this.hasMatrix(plane)) continue;
            out.append("Plane: " + plane + "\n" + this.matrix[plane]);
        }
        for (Range range : this.ranges) {
            out.append(range);
        }
        return out.toString();
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        for (int plane = 0; plane < 17; ++plane) {
            out.append("Matrices:");
            if (!this.hasMatrix(plane)) continue;
            out.append(" " + plane);
        }
        for (Range range : this.ranges) {
            out.append(range);
        }
        return out.toString();
    }

    private void clipRanges() {
        Range range = null;
        Iterator<Range> iterator = this.ranges.iterator();
        while (iterator.hasNext()) {
            int lastPlane;
            range = iterator.next();
            int firstPlane = UnicodeFilter.getPlane(range.first);
            if (this.hasMatrix(firstPlane)) {
                range.first = UnicodeFilter.getLastInPlane(firstPlane) + 1;
                if (range.first > range.last) {
                    iterator.remove();
                    continue;
                }
            }
            if (!this.hasMatrix(lastPlane = UnicodeFilter.getPlane(range.last))) continue;
            range.last = UnicodeFilter.getFirstInPlane(lastPlane) - 1;
            if (range.last >= range.first) continue;
            iterator.remove();
        }
    }

    private void compile() {
        this.populateRanges();
        this.mergeRanges();
        this.clipRanges();
    }

    private boolean hasMatrix(int aPlane) {
        return aPlane >= 0 && aPlane < 17 && this.matrix[aPlane] != null;
    }

    private void mergeRanges() {
        Range previous = null;
        Range current = null;
        Iterator<Range> iterator = this.ranges.iterator();
        while (iterator.hasNext()) {
            current = iterator.next();
            if (previous != null) {
                if (current.first - 1 <= previous.last) {
                    if (current.last > previous.last) {
                        previous.last = current.last;
                    }
                    iterator.remove();
                    continue;
                }
                previous = current;
                continue;
            }
            previous = current;
        }
    }

    private void populateRange(int aPlane) {
        if (this.matrix[aPlane] == null) {
            this.matrix[aPlane] = new UnicodeMatrix(aPlane);
        }
        Range range = null;
        Iterator<Range> iterator = this.ranges.iterator();
        while (iterator.hasNext()) {
            range = iterator.next();
            this.matrix[aPlane].insert(range);
            if (!this.matrix[aPlane].spans(range)) continue;
            iterator.remove();
        }
        this.rangeCount[aPlane] = 0;
    }

    private void populateRanges() {
        for (int plane = 0; plane < 17; ++plane) {
            if (this.rangeCount[plane] <= 30 && this.matrix[plane] == null) continue;
            this.populateRange(plane);
        }
    }

    private void throwUnicodeFilterDoesNotPass(int aCodePoint) throws XcodeException {
        String msg = this.prefix + " " + Integer.toString(aCodePoint, 16).toUpperCase();
        throw XcodeError.UNICODEFILTER_DOES_NOT_PASS(msg);
    }

    private static int getFirstInPlane(int aPlane) {
        return (aPlane & 0x1F) << 16;
    }

    private static int getLastInPlane(int aPlane) {
        return UnicodeFilter.getFirstInPlane(aPlane) + 65535;
    }

    private static int getPlane(int aCodePoint) {
        return (aCodePoint & 0x1F0000) >>> 16;
    }
}

