/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.common;

import com.vgrs.xcode.common.Range;
import com.vgrs.xcode.common.Utf16;
import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;

public class Unicode {
    public static final int MAX = 0x10FFFF;
    public static final int MIN = 0;

    public static void assertValid(int aInput) throws XcodeException {
        if (!Unicode.isValid(aInput)) {
            throw XcodeError.UNICODE_INVALID_VALUE(" " + Integer.toString(aInput, 16));
        }
    }

    public static void assertValid(int[] aInput) throws XcodeException {
        for (int point : aInput) {
            Unicode.assertValid(point);
        }
    }

    public static void assertValid(Range aRange) throws XcodeException {
        Unicode.assertValid(aRange.first);
        Unicode.assertValid(aRange.last);
    }

    public static char[] decode(int aInput) throws XcodeException {
        if (aInput < 65536 || aInput > 0x10FFFF) {
            throw XcodeError.UNICODE_DECODE_INVALID_VALUE(" " + Integer.toString(aInput, 16));
        }
        char[] surrogate = new char[]{(char)((aInput - 65536 >> 10) + 55296), (char)((aInput - 65536 & 0x3FF) + 56320)};
        return surrogate;
    }

    public static char[] decode(int[] aInput) throws XcodeException {
        char[] output;
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        char[] tmp = new char[aInput.length * 2];
        int output_offset = 0;
        for (int element : aInput) {
            if (element > 65535) {
                char[] surrogate = Unicode.decode(element);
                tmp[output_offset++] = surrogate[0];
                tmp[output_offset++] = surrogate[1];
                continue;
            }
            tmp[output_offset++] = (char)element;
        }
        if (output_offset != tmp.length) {
            output = new char[output_offset];
            System.arraycopy(tmp, 0, output, 0, output_offset);
        } else {
            output = tmp;
        }
        return output;
    }

    public static int encode(char aHigh, char aLow) {
        return (aHigh - 55296 << 10) + aLow - 56320 + 65536;
    }

    public static int[] encode(char[] aInput) throws XcodeException {
        int[] output;
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        int[] tmp = new int[aInput.length];
        int output_offset = 0;
        for (int i = 0; i < aInput.length; ++i) {
            if (i + 1 < aInput.length && Utf16.isHighSurrogate(aInput[i]) && Utf16.isLowSurrogate(aInput[i + 1])) {
                tmp[output_offset++] = Unicode.encode(aInput[i], aInput[i + 1]);
                ++i;
                continue;
            }
            tmp[output_offset++] = aInput[i];
        }
        if (output_offset != tmp.length) {
            output = new int[output_offset];
            System.arraycopy(tmp, 0, output, 0, output_offset);
        } else {
            output = tmp;
        }
        return output;
    }

    public static boolean isValid(int aInput) {
        return aInput >= 0 && aInput <= 0x10FFFF;
    }
}

