/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.common;

public class Range
implements Comparable<Range> {
    public int first;
    public int last;
    public boolean isPoint;

    public Range(int aFirst, int aLast) {
        if (aFirst <= aLast) {
            this.first = aFirst;
            this.last = aLast;
        } else {
            this.first = aLast;
            this.last = aFirst;
        }
        this.isPoint = this.first == this.last;
    }

    public Range(int aFirst) {
        this(aFirst, aFirst);
    }

    @Override
    public int compareTo(Range aOtherRange) {
        if (this.first != aOtherRange.first || this.isPoint || aOtherRange.isPoint) {
            return this.first - aOtherRange.first;
        }
        return this.last - aOtherRange.last;
    }

    public boolean has(int aPoint) {
        return aPoint >= this.first && aPoint <= this.last;
    }

    public boolean hasAny(int[] aPoints) {
        if (aPoints != null) {
            for (int point : aPoints) {
                if (!this.has(point)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAll(int[] aPoints) {
        if (aPoints != null) {
            for (int point : aPoints) {
                if (this.has(point)) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("(");
        out.append(Integer.toString(this.first, 16));
        if (!this.isPoint) {
            out.append("," + Integer.toString(this.last, 16));
        }
        out.append(")");
        return out.toString();
    }
}

