/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.common;

import com.vgrs.xcode.common.Utf16;
import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class Native {
    public static final String UTF8 = "UTF8";
    public static final String DOUBLE_UTF8 = "DOUBLE_UTF8";
    public static final String[] ENCODINGS = new String[]{"ASCII", "Big5", "Big5_HKSCS", "Big5_Solaris", "Cp037", "Cp1006", "Cp1025", "Cp1026", "Cp1046", "Cp1047", "Cp1097", "Cp1098", "Cp1112", "Cp1122", "Cp1123", "Cp1124", "Cp1140", "Cp1141", "Cp1142", "Cp1143", "Cp1144", "Cp1145", "Cp1146", "Cp1147", "Cp1148", "Cp1149", "Cp1250", "Cp1251", "Cp1252", "Cp1253", "Cp1254", "Cp1255", "Cp1256", "Cp1257", "Cp1258", "Cp1381", "Cp1383", "Cp273", "Cp277", "Cp278", "Cp280", "Cp284", "Cp285", "Cp297", "Cp33722", "Cp420", "Cp424", "Cp437", "Cp500", "Cp737", "Cp775", "Cp838", "Cp850", "Cp852", "Cp855", "Cp856", "Cp857", "Cp858", "Cp860", "Cp861", "Cp862", "Cp863", "Cp864", "Cp865", "Cp866", "Cp868", "Cp869", "Cp870", "Cp871", "Cp874", "Cp875", "Cp918", "Cp921", "Cp922", "Cp930", "Cp933", "Cp935", "Cp937", "Cp939", "Cp942", "Cp942C", "Cp943", "Cp943C", "Cp948", "Cp949", "Cp949C", "Cp950", "Cp964", "Cp970", "EUC_CN", "EUC_JP", "EUC_JP_LINUX", "EUC_KR", "EUC_TW", "GB18030", "GBK", "ISCII91", "ISO2022_CN_CNS", "ISO2022_CN_GB", "ISO2022JP", "ISO2022KR", "ISO8859_1", "ISO8859_13", "ISO8859_15", "ISO8859_2", "ISO8859_3", "ISO8859_4", "ISO8859_5", "ISO8859_6", "ISO8859_7", "ISO8859_8", "ISO8859_9", "JISAutoDetect", "KOI8_R", "MacArabic", "MacCentralEurope", "MacCroatian", "MacCyrillic", "MacDingbat", "MacGreek", "MacHebrew", "MacIceland", "MacRoman", "MacRomania", "MacSymbol", "MacThai", "MacTurkish", "MacUkraine", "MS874", "MS932", "MS936", "MS949", "MS950", "MS950_HKSCS", "SJIS", "TIS620", "UnicodeBig", "UnicodeBigUnmarked", "UnicodeLittle", "UnicodeLittleUnmarked", "UTF-16", "UTF8"};

    public static byte[] getEncoding(String aInput) throws XcodeException {
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length() == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        char[] c = aInput.toCharArray();
        if (!Utf16.isNative(c)) {
            throw XcodeError.NATIVE_INVALID_ENCODING();
        }
        return Utf16.contract(c);
    }

    private static byte[] internalEncode(String aInput, String aEncoding) throws XcodeException {
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        try {
            return aInput.getBytes(aEncoding);
        }
        catch (UnsupportedEncodingException x) {
            throw XcodeError.UNSUPPORTED_ENCODING(": " + aEncoding);
        }
        catch (Exception x) {
            throw XcodeError.NATIVE_INVALID_ENCODING(": " + aEncoding);
        }
    }

    public static Map<String, String> encode(String aInput) throws XcodeException {
        return Native.encode(aInput, ENCODINGS);
    }

    public static String encode(String aInput, String aEncoding) throws XcodeException {
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length() == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        byte[] output = null;
        String check = null;
        if (aEncoding.equals(DOUBLE_UTF8)) {
            output = Native.internalEncode(new String(Native.internalEncode(aInput, UTF8)), UTF8);
            check = Native.internalDecode(Native.getEncoding(Native.internalDecode(output, UTF8)), UTF8);
        } else {
            output = Native.internalEncode(aInput, aEncoding);
            check = Native.internalDecode(output, aEncoding);
        }
        if (!aInput.equals(check)) {
            throw XcodeError.NATIVE_INVALID_ENCODING(": " + aEncoding);
        }
        return new String(Utf16.expand(output));
    }

    public static Map<String, String> encode(String aInput, String[] aEncodings) throws XcodeException {
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length() == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        HashMap<String, String> results = new HashMap<String, String>();
        for (String aEncoding : aEncodings) {
            try {
                results.put(aEncoding, Native.encode(aInput, aEncoding));
            }
            catch (XcodeException x) {
                // empty catch block
            }
        }
        return results;
    }

    public static Set<String> encodeToSet(String aInput) throws XcodeException {
        return Native.encodeToSet(aInput, ENCODINGS);
    }

    public static Set<String> encodeToSet(String aInput, String[] aEncodings) throws XcodeException {
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length() == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        HashSet<String> results = new HashSet<String>();
        for (String aEncoding : aEncodings) {
            try {
                results.add(Native.encode(aInput, aEncoding));
            }
            catch (XcodeException x) {
                // empty catch block
            }
        }
        return results;
    }

    private static String internalDecode(byte[] aInput, String aEncoding) throws XcodeException {
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        try {
            return new String(aInput, aEncoding);
        }
        catch (UnsupportedEncodingException x) {
            throw XcodeError.UNSUPPORTED_ENCODING(": " + aEncoding);
        }
    }

    public static Map<String, String> decode(byte[] aInput) throws XcodeException {
        return Native.decode(aInput, ENCODINGS);
    }

    public static String decode(byte[] aInput, String aEncoding) throws XcodeException {
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        String output = null;
        byte[] check = null;
        if (aEncoding.equals(DOUBLE_UTF8)) {
            output = Native.internalDecode(Native.getEncoding(Native.internalDecode(aInput, UTF8)), UTF8);
            check = Native.internalEncode(new String(Native.internalEncode(output, UTF8)), UTF8);
        } else {
            output = Native.internalDecode(aInput, aEncoding);
            check = Native.internalEncode(output, aEncoding);
        }
        if (!Arrays.equals(check, aInput)) {
            throw XcodeError.NATIVE_INVALID_ENCODING(": " + aEncoding);
        }
        return output;
    }

    public static Map<String, String> decode(byte[] aInput, String[] aEncodings) throws XcodeException {
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        HashMap<String, String> results = new HashMap<String, String>();
        for (String aEncoding : aEncodings) {
            try {
                results.put(aEncoding, Native.decode(aInput, aEncoding));
            }
            catch (XcodeException x) {
                // empty catch block
            }
        }
        return results;
    }

    public static Set<String> decodeToSet(byte[] aInput) throws XcodeException {
        return Native.decodeToSet(aInput, ENCODINGS);
    }

    public static Set<String> decodeToSet(byte[] aInput, String[] aEncodings) throws XcodeException {
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        HashSet<String> results = new HashSet<String>();
        for (String aEncoding : aEncodings) {
            try {
                results.add(Native.decode(aInput, aEncoding));
            }
            catch (XcodeException x) {
                // empty catch block
            }
        }
        return results;
    }
}

