/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.common;

import com.vgrs.xcode.common.Unicode;
import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;
import java.util.StringTokenizer;

public final class Hex {
    public static String encode(byte[] aInput) throws XcodeException {
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        StringBuilder sb = new StringBuilder();
        for (byte element : aInput) {
            sb.append(Integer.toString((char)element & 0xFF, 16));
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String encode(char[] aInput) throws XcodeException {
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        StringBuilder sb = new StringBuilder();
        for (char element : aInput) {
            sb.append(Integer.toString(element, 16));
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String encode(int[] aInput) throws XcodeException {
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        StringBuilder sb = new StringBuilder();
        for (int element : aInput) {
            sb.append(Integer.toString(element, 16));
            sb.append(" ");
        }
        return sb.toString();
    }

    public static byte[] decodeBytes(String aInput) throws XcodeException {
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length() == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        StringTokenizer st = new StringTokenizer(aInput);
        byte[] output = new byte[st.countTokens()];
        int output_offset = 0;
        String token = null;
        while (st.hasMoreTokens()) {
            token = st.nextToken().toUpperCase();
            if (token.startsWith("\\U") || token.startsWith("0X")) {
                token = token.substring(2);
            }
            try {
                if (token.length() > 2) {
                    throw XcodeError.HEX_DECODE_ONE_BYTE_EXCEEDED(aInput);
                }
                output[output_offset++] = (byte)Integer.parseInt(token, 16);
            }
            catch (NumberFormatException x) {
                throw XcodeError.HEX_DECODE_INVALID_FORMAT(aInput);
            }
        }
        return output;
    }

    public static char[] decodeChars(String aInput) throws XcodeException {
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length() == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        StringTokenizer st = new StringTokenizer(aInput);
        char[] output = new char[st.countTokens()];
        int output_offset = 0;
        String token = null;
        while (st.hasMoreTokens()) {
            token = st.nextToken().toUpperCase();
            if (token.startsWith("\\U") || token.startsWith("0X")) {
                token = token.substring(2);
            }
            try {
                if (token.length() > 4) {
                    throw XcodeError.HEX_DECODE_TWO_BYTES_EXCEEDED(aInput);
                }
                output[output_offset++] = (char)Integer.parseInt(token, 16);
            }
            catch (NumberFormatException x) {
                throw XcodeError.HEX_DECODE_INVALID_FORMAT(aInput);
            }
        }
        return output;
    }

    public static int[] decodeInts(String aInput) throws XcodeException {
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length() == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        StringTokenizer st = new StringTokenizer(aInput);
        int[] output = new int[st.countTokens()];
        int output_offset = 0;
        String token = null;
        while (st.hasMoreTokens()) {
            token = st.nextToken().toUpperCase();
            if (token.startsWith("\\U") || token.startsWith("0X")) {
                token = token.substring(2);
            }
            try {
                if (token.length() > 8) {
                    throw XcodeError.HEX_DECODE_FOUR_BYTES_EXCEEDED(aInput);
                }
                output[output_offset++] = Integer.parseInt(token, 16);
            }
            catch (NumberFormatException x) {
                throw XcodeError.HEX_DECODE_INVALID_FORMAT(aInput);
            }
        }
        return Unicode.encode(Unicode.decode(output));
    }
}

