/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.common;

import com.vgrs.xcode.util.XcodeError;
import com.vgrs.xcode.util.XcodeException;

public final class Base32 {
    public static final byte ZERO = 0;

    public static char[] encode(byte[] aInput) throws XcodeException {
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        int outputLength = (aInput.length * 8 + 4) / 5;
        char[] output = new char[outputLength];
        int offset = 0;
        byte last = 0;
        byte next = 0;
        try {
            block15: for (int i = 0; i < aInput.length; ++i) {
                last = next;
                next = aInput[i];
                switch (i % 5) {
                    case 0: {
                        output[offset++] = Base32.map((byte)((next & 0xF8) >> 3));
                        continue block15;
                    }
                    case 1: {
                        output[offset++] = Base32.map((byte)((last & 7) << 2 | (next & 0xC0) >> 6));
                        output[offset++] = Base32.map((byte)((next & 0x3E) >> 1));
                        continue block15;
                    }
                    case 2: {
                        output[offset++] = Base32.map((byte)((last & 1) << 4 | (next & 0xF0) >> 4));
                        continue block15;
                    }
                    case 3: {
                        output[offset++] = Base32.map((byte)((last & 0xF) << 1 | (next & 0x80) >> 7));
                        output[offset++] = Base32.map((byte)((next & 0x7C) >> 2));
                        continue block15;
                    }
                    case 4: {
                        output[offset++] = Base32.map((byte)((last & 3) << 3 | (next & 0xE0) >> 5));
                        output[offset++] = Base32.map((byte)(next & 0x1F));
                    }
                }
            }
            switch (aInput.length % 5) {
                case 1: {
                    output[offset++] = Base32.map((byte)((next & 7) << 2));
                    break;
                }
                case 2: {
                    output[offset++] = Base32.map((byte)((next & 1) << 4));
                    break;
                }
                case 3: {
                    output[offset++] = Base32.map((byte)((next & 0xF) << 1));
                    break;
                }
                case 4: {
                    output[offset++] = Base32.map((byte)((next & 3) << 3));
                }
            }
        }
        catch (IndexOutOfBoundsException x) {
            throw XcodeError.BASE32_ENCODE_BIT_OVERFLOW();
        }
        return output;
    }

    public static byte[] decode(char[] aInput) throws XcodeException {
        if (aInput == null) {
            throw XcodeError.NULL_ARGUMENT();
        }
        if (aInput.length == 0) {
            throw XcodeError.EMPTY_ARGUMENT();
        }
        int mod8 = aInput.length % 8;
        if (mod8 == 1 || mod8 == 3 || mod8 == 6) {
            throw XcodeError.BASE32_DECODE_INVALID_SIZE();
        }
        int outputLength = aInput.length * 5 / 8;
        byte[] output = new byte[outputLength];
        int outputOffset = 0;
        int inputOffset = 0;
        int target = 0;
        int cursor = 0;
        int delta = 0;
        try {
            while (inputOffset < aInput.length) {
                delta = 0;
                switch (target % 5) {
                    case 0: {
                        cursor = Base32.demap(aInput[inputOffset++]);
                        delta = (byte)(delta | cursor << 3);
                        cursor = Base32.demap(aInput[inputOffset++]);
                        delta = (byte)(delta | cursor >> 2);
                        output[outputOffset++] = delta;
                        break;
                    }
                    case 1: {
                        delta = (byte)(delta | (cursor & 3) << 6);
                        cursor = Base32.demap(aInput[inputOffset++]);
                        delta = (byte)(delta | cursor << 1);
                        cursor = Base32.demap(aInput[inputOffset++]);
                        delta = (byte)(delta | cursor >> 4);
                        output[outputOffset++] = delta;
                        break;
                    }
                    case 2: {
                        delta = (byte)(delta | (cursor & 0xF) << 4);
                        cursor = Base32.demap(aInput[inputOffset++]);
                        delta = (byte)(delta | cursor >> 1);
                        output[outputOffset++] = delta;
                        break;
                    }
                    case 3: {
                        delta = (byte)(delta | (cursor & 1) << 7);
                        cursor = Base32.demap(aInput[inputOffset++]);
                        delta = (byte)(delta | cursor << 2);
                        cursor = Base32.demap(aInput[inputOffset++]);
                        delta = (byte)(delta | cursor >> 3);
                        output[outputOffset++] = delta;
                        break;
                    }
                    case 4: {
                        delta = (byte)(delta | (cursor & 7) << 5);
                        cursor = Base32.demap(aInput[inputOffset++]);
                        delta = (byte)(delta | cursor);
                        output[outputOffset++] = delta;
                    }
                }
                ++target;
            }
            int mod5 = target % 5;
            if (mod5 == 1 && (cursor & 3) > 0 || mod5 == 2 && (cursor & 0xF) > 0 || mod5 == 3 && (cursor & 1) > 0 || mod5 == 4 && (cursor & 7) > 0) {
                throw XcodeError.BASE32_DECODE_INVALID_BIT_SEQUENCE();
            }
        }
        catch (IndexOutOfBoundsException x) {
            throw XcodeError.BASE32_DECODE_BIT_OVERFLOW();
        }
        return output;
    }

    private static char map(byte aInput) throws XcodeException {
        if (aInput <= 25) {
            return (char)(aInput + 97);
        }
        if (aInput <= 31) {
            return (char)(aInput + 24);
        }
        throw XcodeError.BASE32_MAP_BIT_OVERFLOW();
    }

    private static byte demap(char aInput) throws XcodeException {
        if (aInput >= '2' && aInput <= '7') {
            return (byte)(aInput - 24);
        }
        if (aInput >= 'A' && aInput <= 'Z') {
            return (byte)(aInput - 65);
        }
        if (aInput >= 'a' && aInput <= 'z') {
            return (byte)(aInput - 97);
        }
        throw XcodeError.BASE32_DEMAP_INVALID_BASE32_CHAR();
    }
}

