/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.cmdline.unicodedata;

import com.vgrs.xcode.cmdline.CmdLine;
import com.vgrs.xcode.cmdline.CommandLineArgs;
import com.vgrs.xcode.common.Hex;
import com.vgrs.xcode.common.Unicode;
import com.vgrs.xcode.common.unicodedata.UnicodeData;
import com.vgrs.xcode.util.Datafile;
import com.vgrs.xcode.util.Debug;
import com.vgrs.xcode.util.XcodeException;
import java.io.File;
import java.util.Iterator;

public class UnicodeDataCmdLine
extends CmdLine {
    public UnicodeDataCmdLine(String[] args) {
        super(args);
    }

    @Override
    public String getUsageOptions() {
        return "file=<file>";
    }

    public static void main(String[] args) {
        UnicodeDataCmdLine cmd = new UnicodeDataCmdLine(args);
        CommandLineArgs options = cmd.getOptions();
        if (!options.has("file")) {
            cmd.showUsage();
            return;
        }
        File inputFile = new File(options.get("file"));
        int[] input_decoded = null;
        String derivedProperty = null;
        String scriptProperty = null;
        String bidiProperty = null;
        char joiningTypeProperty = '\u0000';
        int canonicalCombiningClass = -1;
        boolean prohibitedCodePointFlag = false;
        boolean normalizedNFCCodePointFlag = false;
        boolean combiningMarkFlag = false;
        try {
            Iterator<String> data = Datafile.getIterator(inputFile);
            while (data.hasNext()) {
                String input = data.next();
                if (input == null || (input = input.trim()).length() == 0 || input.charAt(0) == '#') continue;
                derivedProperty = null;
                scriptProperty = null;
                bidiProperty = null;
                joiningTypeProperty = '\u0000';
                try {
                    input_decoded = Hex.decodeInts(input);
                }
                catch (XcodeException x) {
                    input_decoded = Unicode.encode(input.toCharArray());
                }
                if (input_decoded.length > 1) {
                    for (int j = input_decoded[0]; j <= input_decoded[1]; ++j) {
                        derivedProperty = UnicodeData.getCodePointDerivedProperty(j).toString();
                        scriptProperty = UnicodeData.getScript(j);
                        bidiProperty = UnicodeData.getBidiClass(j);
                        joiningTypeProperty = UnicodeData.getJoiningType(j);
                        canonicalCombiningClass = UnicodeData.getCanonicalClass(j);
                        prohibitedCodePointFlag = UnicodeData.isDisallowedOrUnassignedCodePoint(j);
                        normalizedNFCCodePointFlag = UnicodeData.isNormalized(input_decoded);
                        combiningMarkFlag = UnicodeData.isCombiningMark(j);
                        Debug.log(UnicodeDataCmdLine.toHexString(j) + " ; " + "DerivedProperty <" + derivedProperty + "> ; " + "Script <" + scriptProperty + ">" + " ; " + "BidiClass <" + bidiProperty + ">" + " ; " + "JoiningType <" + joiningTypeProperty + ">" + " ; " + "CanonicalCombiningClass <" + canonicalCombiningClass + ">" + " ; " + "isCombiningMark <" + Boolean.toString(combiningMarkFlag) + ">" + " ; " + "isProhibitedCodePoint <" + Boolean.toString(prohibitedCodePointFlag) + ">" + " ; " + "isNormalized <" + Boolean.toString(normalizedNFCCodePointFlag) + ">");
                    }
                    continue;
                }
                derivedProperty = UnicodeData.getCodePointDerivedProperty(input_decoded[0]).toString();
                scriptProperty = UnicodeData.getScript(input_decoded[0]);
                bidiProperty = UnicodeData.getBidiClass(input_decoded[0]);
                joiningTypeProperty = UnicodeData.getJoiningType(input_decoded[0]);
                canonicalCombiningClass = UnicodeData.getCanonicalClass(input_decoded[0]);
                prohibitedCodePointFlag = UnicodeData.isDisallowedOrUnassignedCodePoint(input_decoded[0]);
                normalizedNFCCodePointFlag = UnicodeData.isNormalized(input_decoded);
                combiningMarkFlag = UnicodeData.isCombiningMark(input_decoded[0]);
                Debug.log(UnicodeDataCmdLine.toHexString(input_decoded[0]) + " ; " + "DerivedProperty <" + derivedProperty + ">" + " ; " + "Script <" + scriptProperty + ">" + " ; " + "BidiClass <" + bidiProperty + ">" + " ; " + "JoiningType <" + joiningTypeProperty + ">" + " ; " + "CanonicalCombiningClass <" + canonicalCombiningClass + ">" + " ; " + "isCombiningMark <" + Boolean.toString(combiningMarkFlag) + ">" + " ; " + "isProhibitedCodePoints <" + Boolean.toString(prohibitedCodePointFlag) + ">" + " ; " + "isNormalized <" + Boolean.toString(normalizedNFCCodePointFlag) + ">");
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static String leftPad(String s) {
        String result = s;
        if (result.length() < 4) {
            for (int i = result.length(); i < 4; ++i) {
                result = "0" + result;
            }
        }
        return result;
    }

    private static String toHexString(int input) {
        if (input < 0) {
            return null;
        }
        String output = Integer.toString(input, 16);
        return UnicodeDataCmdLine.leftPad(output.toUpperCase());
    }
}

