/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.cmdline.idna;

import com.vgrs.xcode.cmdline.CmdLine;
import com.vgrs.xcode.cmdline.CommandLineArgs;
import com.vgrs.xcode.common.Hex;
import com.vgrs.xcode.common.Utf16;
import com.vgrs.xcode.idna.Idna;
import com.vgrs.xcode.idna.Punycode;
import com.vgrs.xcode.util.Datafile;
import com.vgrs.xcode.util.Debug;
import com.vgrs.xcode.util.XcodeException;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;

public class PunycodeCmdLine
extends CmdLine {
    private static Punycode punycode;

    public PunycodeCmdLine(String[] args) {
        super(args);
    }

    public static void main(String[] args) {
        PunycodeCmdLine cmd = new PunycodeCmdLine(args);
        CommandLineArgs options = cmd.getOptions();
        if (!options.has("file")) {
            cmd.showUsage();
            return;
        }
        File input = new File(options.get("file"));
        boolean useStd3AsciiRules = true;
        if (options.has("3")) {
            useStd3AsciiRules = false;
        }
        punycode = new Punycode(useStd3AsciiRules);
        if (options.has("encode")) {
            PunycodeCmdLine.testEncode(input);
        } else if (options.has("decode")) {
            PunycodeCmdLine.testDecode(input);
        } else {
            cmd.showUsage();
        }
    }

    public static void testEncode(File input) {
        try {
            Iterator<String> data = Datafile.getIterator(input);
            while (data.hasNext()) {
                PunycodeCmdLine.testEncode(data.next());
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static void testDecode(File input) {
        try {
            Iterator<String> data = Datafile.getIterator(input);
            while (data.hasNext()) {
                PunycodeCmdLine.testDecode(data.next());
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static void testEncode(String input) throws XcodeException {
        int[] inputarray = null;
        char[] output = null;
        int[] check = null;
        if (input == null) {
            Debug.pass("");
            return;
        }
        String inputString = input.trim();
        if (inputString.length() == 0 || inputString.charAt(0) == '#') {
            Debug.pass(inputString);
            return;
        }
        try {
            inputarray = Hex.decodeInts(inputString);
            output = punycode.domainEncode(inputarray);
        }
        catch (XcodeException x) {
            Debug.fail(inputString + "\tERROR:" + x.getCode() + "\t" + x.getMessage());
            return;
        }
        try {
            check = punycode.domainDecode(output);
        }
        catch (XcodeException x) {
            Debug.fail(inputString + "\tFATAL:" + x.getCode() + "\t" + x.getMessage());
            return;
        }
        for (int i = 0; i < inputarray.length; ++i) {
            for (int j = 1; j < Idna.INT_DELIMITERS.length; ++j) {
                if (inputarray[i] != Idna.INT_DELIMITERS[j]) continue;
                inputarray[i] = 46;
            }
        }
        if (!Arrays.equals(inputarray, check)) {
            Debug.fail(inputString + "\tMISMATCH\t" + Hex.encode(check));
            return;
        }
        Debug.pass(new String(output));
    }

    public static void testDecode(String input) throws XcodeException {
        char[] inputarray = null;
        int[] output = null;
        char[] check = null;
        if (input == null) {
            Debug.pass("");
            return;
        }
        String inputString = input.trim();
        if (inputString.length() == 0 || inputString.charAt(0) == '#') {
            Debug.pass(inputString);
            return;
        }
        try {
            inputarray = inputString.toCharArray();
            output = punycode.domainDecode(inputarray);
        }
        catch (XcodeException x) {
            Debug.fail(inputString + "\tERROR:" + x.getCode() + "\t" + x.getMessage());
            return;
        }
        try {
            check = punycode.domainEncode(output);
        }
        catch (XcodeException x) {
            Debug.fail(inputString + "\tFATAL:" + x.getCode() + "\t" + x.getMessage());
            return;
        }
        if (Utf16.isDnsCompatible(inputarray) && !inputString.equalsIgnoreCase(new String(check))) {
            Debug.fail(inputString + " MISMATCH " + new String(check));
            return;
        }
        Debug.pass(Hex.encode(output));
    }

    @Override
    public String getUsageOptions() {
        return " [-3] (--encode | --decode) file=<file>\n-3 => do NOT enforce Std 3 Ascii Rules";
    }
}

