/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.cmdline.idna;

import com.vgrs.xcode.cmdline.CmdLine;
import com.vgrs.xcode.cmdline.CommandLineArgs;
import com.vgrs.xcode.common.Hex;
import com.vgrs.xcode.idna.Normalize;
import com.vgrs.xcode.util.Datafile;
import com.vgrs.xcode.util.Debug;
import com.vgrs.xcode.util.XcodeException;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.StringTokenizer;

public class NormalizeCmdLine
extends CmdLine {
    public NormalizeCmdLine(String[] args) {
        super(args);
    }

    public static void main(String[] args) {
        NormalizeCmdLine cmd = new NormalizeCmdLine(args);
        CommandLineArgs options = cmd.getOptions();
        if (!options.has("file")) {
            cmd.showUsage();
            return;
        }
        File input = new File(options.get("file"));
        if (options.has("c")) {
            NormalizeCmdLine.testConformance(input);
        } else {
            NormalizeCmdLine.testExecute(input);
        }
    }

    public static void testExecute(File input) {
        try {
            Iterator<String> data = Datafile.getIterator(input);
            while (data.hasNext()) {
                NormalizeCmdLine.testExecute(data.next());
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static void testExecute(String input) throws XcodeException {
        int[] output = null;
        if (input == null) {
            Debug.pass("");
            return;
        }
        String inputString = input.trim();
        if (inputString.length() == 0 || inputString.charAt(0) == '#') {
            Debug.pass(inputString);
            return;
        }
        try {
            output = Normalize.execute(Hex.decodeInts(inputString));
        }
        catch (XcodeException x) {
            Debug.fail(inputString + "\tERROR:" + x.getCode() + "\t" + x.getMessage());
            return;
        }
        Debug.pass(Hex.encode(output));
    }

    public static void testConformance(File input) {
        try {
            Iterator<String> data = Datafile.getIterator(input);
            while (data.hasNext()) {
                NormalizeCmdLine.testConformance(data.next());
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static void testConformance(String input) {
        if (input == null) {
            Debug.pass("");
            return;
        }
        String inputString = input.trim();
        int hashIndex = inputString.indexOf(35);
        if (hashIndex > 0) {
            inputString = inputString.substring(0, hashIndex);
            inputString = inputString.trim();
        }
        if (inputString.length() == 0 || inputString.charAt(0) == '#' || inputString.charAt(0) == '@') {
            return;
        }
        StringTokenizer st = new StringTokenizer(inputString, ";");
        int tokenCount = st.countTokens();
        if (tokenCount < 5) {
            Debug.fail(inputString + "\tERROR: Invalid number of columns");
            return;
        }
        int index = 0;
        String[] column = new String[tokenCount];
        while (st.hasMoreTokens()) {
            column[index++] = st.nextToken();
        }
        int[][] c = new int[5][];
        try {
            for (index = 0; index < 5; ++index) {
                c[index] = Hex.decodeInts(column[index]);
            }
        }
        catch (XcodeException x) {
            Debug.fail(inputString + "\tERROR:[" + column[index] + "]" + x.getCode() + "\t" + x.getMessage());
            return;
        }
        try {
            for (int i = 0; i < 5; ++i) {
                int[] nfkc = Normalize.execute(NormalizeCmdLine.getCopy(c[i]));
                if (Arrays.equals(c[3], nfkc)) continue;
                Debug.fail(inputString + "\tERROR: conformance test failed: col[4] = '" + Hex.encode(c[3]) + "': col[" + (i + 1) + "] = '" + Hex.encode(c[i]) + "': NFKC[" + (i + 1) + "] = '" + Hex.encode(nfkc) + "'");
            }
        }
        catch (XcodeException x) {
            Debug.fail(inputString + "\tERROR:" + x.getCode() + "\t" + x.getMessage());
            return;
        }
    }

    private static int[] getCopy(int[] arr) {
        int[] copy = new int[arr.length];
        System.arraycopy(arr, 0, copy, 0, arr.length);
        return copy;
    }

    @Override
    public String getUsageOptions() {
        return "[-c] file=<file>";
    }
}

