/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.cmdline.idna;

import com.vgrs.xcode.cmdline.CmdLine;
import com.vgrs.xcode.cmdline.CommandLineArgs;
import com.vgrs.xcode.common.Hex;
import com.vgrs.xcode.common.Unicode;
import com.vgrs.xcode.common.Utf16;
import com.vgrs.xcode.idna.Ace;
import com.vgrs.xcode.idna.Idna;
import com.vgrs.xcode.idna.Punycode;
import com.vgrs.xcode.idna.Race;
import com.vgrs.xcode.util.Datafile;
import com.vgrs.xcode.util.Debug;
import com.vgrs.xcode.util.XcodeException;
import java.io.File;
import java.util.Iterator;

public class IdnaCmdLine
extends CmdLine {
    private Idna idna = null;

    public IdnaCmdLine(String[] args) {
        super(args);
    }

    public void setIdna(Idna idna) {
        this.idna = idna;
    }

    public static void main(String[] args) throws XcodeException {
        IdnaCmdLine cmd = new IdnaCmdLine(args);
        CommandLineArgs options = cmd.getOptions();
        Ace ace = null;
        if (!options.has("file")) {
            cmd.showUsage();
            return;
        }
        boolean useStd3AsciiRules = true;
        boolean idna2008Protocol = true;
        boolean toUnicodeExceptionFlag = false;
        boolean isPunycode = true;
        if (options.has("3")) {
            useStd3AsciiRules = false;
        }
        if (options.has("c")) {
            idna2008Protocol = false;
        }
        if (options.has("r")) {
            isPunycode = false;
        }
        if (options.has("x")) {
            toUnicodeExceptionFlag = true;
        }
        File input = new File(options.get("file"));
        ace = isPunycode ? new Punycode(useStd3AsciiRules) : new Race(useStd3AsciiRules);
        Idna idna = new Idna(ace, toUnicodeExceptionFlag, idna2008Protocol);
        cmd.setIdna(idna);
        if (options.has("toAscii")) {
            cmd.testToAscii(input);
        } else if (options.has("toUnicode")) {
            cmd.testToUnicode(input);
        } else {
            cmd.showUsage();
            return;
        }
    }

    public void testToAscii(File input) {
        try {
            Iterator<String> data = Datafile.getIterator(input);
            while (data.hasNext()) {
                this.testToAscii(data.next());
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void testToUnicode(File input) {
        try {
            Iterator<String> data = Datafile.getIterator(input);
            while (data.hasNext()) {
                this.testToUnicode(data.next());
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void testToAscii(String input) {
        int[] input_decoded = null;
        char[] output = null;
        if (input == null) {
            Debug.pass("");
            return;
        }
        String inputString = input.trim();
        if (inputString.length() == 0 || inputString.charAt(0) == '#') {
            Debug.pass(inputString);
            return;
        }
        try {
            try {
                input_decoded = Hex.decodeInts(inputString);
            }
            catch (XcodeException x) {
                input_decoded = Unicode.encode(inputString.toCharArray());
            }
            output = this.idna.domainToAscii(input_decoded);
        }
        catch (XcodeException x) {
            Debug.fail(inputString + "\tERROR:" + x.getCode() + "\t" + x.getMessage());
            return;
        }
        Debug.pass(new String(output));
    }

    public void testToUnicode(String input) throws XcodeException {
        char[] input_decoded = null;
        int[] output = null;
        if (input == null) {
            Debug.pass("");
            return;
        }
        String inputString = input.trim();
        if (inputString.length() == 0 || inputString.charAt(0) == '#') {
            Debug.pass(inputString);
            return;
        }
        try {
            try {
                input_decoded = Hex.decodeChars(inputString);
            }
            catch (XcodeException x) {
                try {
                    input_decoded = Unicode.decode(Hex.decodeInts(inputString));
                }
                catch (XcodeException x2) {
                    input_decoded = inputString.toCharArray();
                }
            }
            output = this.idna.domainToUnicode(input_decoded);
        }
        catch (XcodeException x) {
            Debug.fail(inputString + "\tERROR:" + x.getCode() + "\t" + x.getMessage());
            return;
        }
        if (Utf16.isPrintable(output)) {
            Debug.pass(new String(Utf16.contract(output)));
        } else {
            Debug.pass(Hex.encode(output));
        }
    }

    @Override
    public String getUsageOptions() {
        return "[-3crx] file=<file> (--toAscii | --toUnicode)\n -3 => do NOT enforce Std 3 Ascii Rules\n -c => do NOT perform IDNA2008 Protocol validation\n -r => use Race for ACE encoding (Punycode by default)\n -x => allow eXceptions during toUnicode\n";
    }
}

