/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.cmdline.idna;

import com.vgrs.xcode.common.Hex;
import com.vgrs.xcode.common.Unicode;
import com.vgrs.xcode.idna.Idna;
import com.vgrs.xcode.idna.Punycode;
import com.vgrs.xcode.util.XcodeException;

public class DemoCmdLine {
    private static boolean useStd3AsciiRules = true;
    private static boolean throwExceptions = true;
    private static boolean idnaRegistrationProtocol = true;

    public static void main(String[] args) throws XcodeException {
        Punycode ace = new Punycode(useStd3AsciiRules);
        Idna idna = new Idna(ace, throwExceptions, idnaRegistrationProtocol);
        String utf16 = "r\u00e9sum\u00e9";
        int[] unicode = Unicode.encode("r\u00e9sum\u00e9".toCharArray());
        String punycode = new String(idna.domainToAscii(unicode));
        int[] check = idna.domainToUnicode(punycode.toCharArray());
        System.out.println("utf16: r\u00e9sum\u00e9");
        System.out.println("unicode: " + Hex.encode(unicode));
        System.out.println("punycode: " + punycode);
        System.out.println("check: " + Hex.encode(check));
    }
}

