/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.cmdline.idna;

import com.vgrs.xcode.cmdline.CmdLine;
import com.vgrs.xcode.cmdline.CommandLineArgs;
import com.vgrs.xcode.common.Hex;
import com.vgrs.xcode.idna.Bidi;
import com.vgrs.xcode.util.Datafile;
import com.vgrs.xcode.util.Debug;
import com.vgrs.xcode.util.XcodeException;
import java.io.File;
import java.util.Iterator;

public class BidiCmdLine
extends CmdLine {
    public BidiCmdLine(String[] args) {
        super(args);
    }

    public static void main(String[] args) {
        BidiCmdLine cmd = new BidiCmdLine(args);
        CommandLineArgs options = cmd.getOptions();
        if (!options.has("file")) {
            cmd.showUsage();
            return;
        }
        BidiCmdLine.testExecute(new File(options.get("file")));
    }

    public static void testExecute(File input) {
        try {
            Iterator<String> data = Datafile.getIterator(input);
            while (data.hasNext()) {
                BidiCmdLine.testExecute(data.next());
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static void testExecute(String input) {
        if (input == null) {
            Debug.pass("");
            return;
        }
        String inputString = input.trim();
        if (inputString.length() == 0 || inputString.charAt(0) == '#') {
            Debug.pass(inputString);
            return;
        }
        try {
            Bidi.assertCompliance(Hex.decodeInts(inputString));
        }
        catch (XcodeException x) {
            Debug.fail(inputString + "\tERROR:" + x.getCode() + "\t" + x.getMessage());
            return;
        }
        Debug.pass(inputString);
    }

    @Override
    public String getUsageOptions() {
        return "file=<file>";
    }
}

