/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.cmdline.ext;

import com.vgrs.xcode.cmdline.CmdLine;
import com.vgrs.xcode.cmdline.CommandLineArgs;
import com.vgrs.xcode.cmdline.common.Base32CmdLine;
import com.vgrs.xcode.ext.EncodingVariants;
import com.vgrs.xcode.idna.Punycode;
import com.vgrs.xcode.idna.Race;
import com.vgrs.xcode.util.Datafile;
import com.vgrs.xcode.util.Debug;
import com.vgrs.xcode.util.XcodeException;
import java.io.File;
import java.util.Iterator;
import java.util.List;

public class EncodingVariantsCmdLine
extends CmdLine {
    public static EncodingVariants ev;

    public EncodingVariantsCmdLine(String[] args) {
        super(args);
    }

    public static void main(String[] args) {
        Base32CmdLine cmd = new Base32CmdLine(args);
        CommandLineArgs options = cmd.getOptions();
        ev = options.has("r") ? new EncodingVariants(new Race()) : new EncodingVariants(new Punycode());
        if (!options.has("file")) {
            cmd.showUsage();
            return;
        }
        File inputFile = new File(options.get("file"));
        List<String> encodingList = options.getUnassigned();
        String[] encodings = null;
        if (encodingList != null && encodingList.size() > 1) {
            encodings = encodingList.toArray(new String[encodingList.size()]);
        }
        EncodingVariantsCmdLine.testExecute(inputFile, encodings);
    }

    public static void testExecute(File input, String[] encodings) {
        try {
            Iterator<String> data = Datafile.getIterator(input);
            while (data.hasNext()) {
                EncodingVariantsCmdLine.testExecute(data.next(), encodings);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static void testExecute(String input, String[] encodings) {
        String[] output = null;
        if (input == null) {
            Debug.pass("");
            return;
        }
        if ((input = input.trim()).length() == 0 || input.charAt(0) == '#') {
            Debug.pass(input);
            return;
        }
        try {
            output = ev.execute(input, encodings);
        }
        catch (XcodeException x) {
            Debug.fail(input + "\tERROR:" + x.getCode() + "\t" + x.getMessage());
            return;
        }
        if (output == null || output.length == 0) {
            Debug.pass(input + " -> ");
        } else if (output.length == 1) {
            Debug.pass(input + " -> " + output[0]);
        } else {
            System.out.println("\n" + input);
            for (String element : output) {
                Debug.pass("-> " + element);
            }
            System.out.println();
        }
    }

    @Override
    public String getUsageOptions() {
        return "[-r] file=<file> <encoding list>\n -r => use Race for ACE encoding (Punycode by default)";
    }
}

