/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.cmdline.ext;

import com.vgrs.xcode.cmdline.CmdLine;
import com.vgrs.xcode.cmdline.CommandLineArgs;
import com.vgrs.xcode.cmdline.common.Base32CmdLine;
import com.vgrs.xcode.common.Hex;
import com.vgrs.xcode.ext.DCE;
import com.vgrs.xcode.util.Datafile;
import com.vgrs.xcode.util.Debug;
import com.vgrs.xcode.util.XcodeException;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;

public class DCECmdLine
extends CmdLine {
    private static String SWITCH_ENCODE = "encode";
    private static String SWITCH_DECODE = "decode";

    public DCECmdLine(String[] args) {
        super(args);
    }

    public static void main(String[] args) {
        Base32CmdLine cmd = new Base32CmdLine(args);
        CommandLineArgs options = cmd.getOptions();
        if (options.getCount() == 2 && options.has("file")) {
            File inputFile = new File(options.get("file"));
            if (options.has(SWITCH_ENCODE)) {
                DCECmdLine.testEncode(inputFile);
                return;
            }
            if (options.has(SWITCH_DECODE)) {
                DCECmdLine.testDecode(inputFile);
                return;
            }
        }
        cmd.showUsage();
    }

    public static void testEncode(File input) {
        try {
            Iterator<String> data = Datafile.getIterator(input);
            while (data.hasNext()) {
                DCECmdLine.testEncode(data.next());
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static void testDecode(File input) {
        try {
            Iterator<String> data = Datafile.getIterator(input);
            while (data.hasNext()) {
                DCECmdLine.testDecode(data.next());
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static void testEncode(String input) throws XcodeException {
        byte[] inputarray = null;
        char[] output = null;
        byte[] check = null;
        if (input == null) {
            Debug.pass("");
            return;
        }
        if ((input = input.trim()).length() == 0 || input.charAt(0) == '#') {
            Debug.pass(input);
            return;
        }
        try {
            inputarray = Hex.decodeBytes(input);
            output = DCE.encode(inputarray);
        }
        catch (XcodeException x) {
            Debug.fail(input + "\tERROR:" + x.getCode() + "\t" + x.getMessage());
            return;
        }
        try {
            check = DCE.decode(output);
        }
        catch (XcodeException x) {
            Debug.fail(input + " FATAL:" + x.getCode() + " " + x.getMessage());
            return;
        }
        if (!Arrays.equals(inputarray, check)) {
            Debug.fail(input + " MISMATCH " + Hex.encode(check));
            return;
        }
        Debug.pass(new String(output));
    }

    public static void testDecode(String input) throws XcodeException {
        char[] inputarray = null;
        byte[] output = null;
        char[] check = null;
        if (input == null) {
            Debug.pass("");
            return;
        }
        if ((input = input.trim()).length() == 0 || input.charAt(0) == '#') {
            Debug.pass(input);
            return;
        }
        try {
            inputarray = input.toCharArray();
            output = DCE.decode(inputarray);
        }
        catch (XcodeException x) {
            Debug.fail(input + "\tERROR:" + x.getCode() + "\t" + x.getMessage());
            return;
        }
        try {
            check = DCE.encode(output);
        }
        catch (XcodeException x) {
            Debug.fail(input + " FATAL:" + x.getCode() + " " + x.getMessage());
            return;
        }
        if (!input.equalsIgnoreCase(new String(check))) {
            Debug.fail(input + "\tMISMATCH\t" + new String(check));
            return;
        }
        Debug.pass(Hex.encode(output));
    }

    @Override
    public String getUsageOptions() {
        return "(--encode | --decode) file=<file>";
    }
}

