/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.cmdline.ext;

import com.vgrs.xcode.cmdline.CmdLine;
import com.vgrs.xcode.cmdline.CommandLineArgs;
import com.vgrs.xcode.common.Hex;
import com.vgrs.xcode.common.Native;
import com.vgrs.xcode.ext.Convert;
import com.vgrs.xcode.idna.Idna;
import com.vgrs.xcode.idna.Punycode;
import com.vgrs.xcode.idna.Race;
import com.vgrs.xcode.util.Datafile;
import com.vgrs.xcode.util.Debug;
import com.vgrs.xcode.util.XcodeException;
import java.io.File;
import java.util.Iterator;
import java.util.Properties;

public class ConvertCmdLine
extends CmdLine {
    private Convert convert = null;

    @Override
    public String getUsageOptions() {
        return "[-3cx] [--list] file=<file> <input type> <output types>\n -3 => do NOT enforce Std 3 Ascii Rules\n -c => do NOT perform IDNA2008 Protocol validation\n -x => allow eXceptions during toUnicode\n --list => Output a list of supported encoding types\n";
    }

    public ConvertCmdLine(String[] args) {
        super(args);
    }

    public void setConvert(Convert convert) {
        this.convert = convert;
    }

    public static void main(String[] args) throws XcodeException {
        ConvertCmdLine cmd = new ConvertCmdLine(args);
        CommandLineArgs options = cmd.getOptions();
        if (options.has("list")) {
            ConvertCmdLine.listEncodings();
            return;
        }
        if (!options.has("file") || options.getUnassigned().size() < 2) {
            cmd.showUsage();
            return;
        }
        boolean useStd3AsciiRules = true;
        boolean idna2008Protocol = true;
        boolean toUnicodeExceptionFlag = false;
        if (options.has("3")) {
            useStd3AsciiRules = false;
        }
        if (options.has("c")) {
            idna2008Protocol = false;
        }
        if (options.has("x")) {
            toUnicodeExceptionFlag = true;
        }
        File input = new File(options.get("file"));
        String itype = options.getUnassigned().get(0);
        Race race = new Race(useStd3AsciiRules);
        Punycode punycode = new Punycode(useStd3AsciiRules);
        Idna iRace = new Idna(race, toUnicodeExceptionFlag, idna2008Protocol);
        Idna iPunycode = new Idna(punycode, toUnicodeExceptionFlag, idna2008Protocol);
        cmd.setConvert(new Convert(iRace, iPunycode));
        String[] otype = new String[options.getUnassigned().size() - 1];
        for (int i = 1; i < options.getUnassigned().size(); ++i) {
            otype[i - 1] = options.getUnassigned().get(i);
        }
        cmd.testExecute(input, itype, otype);
    }

    private static void listEncodings() {
        for (String element : Native.ENCODINGS) {
            Debug.pass(element);
        }
    }

    private void testExecute(File file, String itype, String[] otype) {
        try {
            Iterator<String> data = Datafile.getIterator(file);
            if (otype != null && otype.length == 1) {
                while (data.hasNext()) {
                    this.testExecute(data.next(), itype, otype[0]);
                }
            } else {
                while (data.hasNext()) {
                    this.testExecute(data.next(), itype, otype);
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    private void testExecute(String input, String itype, String otype) throws XcodeException {
        String output = null;
        if (input == null) {
            Debug.pass("");
            return;
        }
        String inputString = input.trim();
        if (inputString.length() == 0 || inputString.charAt(0) == '#') {
            Debug.pass(inputString);
            return;
        }
        boolean asciiInput = itype.equalsIgnoreCase("RACE") || itype.equalsIgnoreCase("PUNYCODE");
        boolean asciiOutput = otype.equalsIgnoreCase("RACE") || otype.equalsIgnoreCase("PUNYCODE");
        try {
            output = asciiInput ? this.convert.execute(inputString, itype, otype) : this.convert.execute(new String(Hex.decodeBytes(inputString)), itype, otype);
        }
        catch (XcodeException x) {
            Debug.fail(inputString + " ERROR:" + x.getCode() + " " + x.getMessage());
            return;
        }
        if (asciiOutput) {
            Debug.pass(output);
        } else {
            Debug.pass(Hex.encode(Native.getEncoding(output)));
        }
    }

    private void testExecute(String input, String itype, String[] otype) throws XcodeException {
        Properties output;
        if (input == null) {
            Debug.pass("");
            return;
        }
        String inputString = input.trim();
        if (inputString.length() == 0 || inputString.charAt(0) == '#') {
            Debug.pass(inputString);
            return;
        }
        boolean asciiInput = itype.equalsIgnoreCase("RACE") || itype.equalsIgnoreCase("PUNYCODE");
        try {
            output = asciiInput ? this.convert.execute(inputString, itype, otype) : this.convert.execute(new String(Hex.decodeBytes(inputString)), itype, otype);
        }
        catch (XcodeException x) {
            Debug.fail(inputString + " ERROR:" + x.getCode() + " " + x.getMessage());
            return;
        }
        Iterator<Object> iterator = output.keySet().iterator();
        System.out.println("\n" + inputString);
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = output.getProperty(key);
            boolean asciiOutput = key.equalsIgnoreCase("RACE") || key.equalsIgnoreCase("PUNYCODE");
            System.out.print("\t" + key + "\t");
            if (asciiOutput) {
                System.out.println(value);
                continue;
            }
            System.out.println(Hex.encode(Native.getEncoding(value)));
        }
    }
}

