/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.cmdline.common;

import com.vgrs.xcode.cmdline.CmdLine;
import com.vgrs.xcode.cmdline.CommandLineArgs;
import com.vgrs.xcode.common.Hex;
import com.vgrs.xcode.common.Native;
import com.vgrs.xcode.util.Datafile;
import com.vgrs.xcode.util.Debug;
import com.vgrs.xcode.util.XcodeException;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NativeCmdLine
extends CmdLine {
    private static String SWITCH_ENCODE = "encode";
    private static String SWITCH_DECODE = "decode";

    public NativeCmdLine(String[] args) {
        super(args);
    }

    public static void main(String[] args) {
        NativeCmdLine cmd = new NativeCmdLine(args);
        CommandLineArgs options = cmd.getOptions();
        if (!options.has("file") || options.getUnassigned().size() == 0) {
            cmd.showUsage();
            return;
        }
        File inputFile = new File(options.get("file"));
        List<String> encodingList = options.getUnassigned();
        String[] encodings = null;
        if (encodingList != null && encodingList.size() > 0) {
            encodings = encodingList.toArray(new String[encodingList.size()]);
        }
        if (options.has(SWITCH_ENCODE)) {
            NativeCmdLine.testEncode(inputFile, encodings);
        } else if (options.has(SWITCH_DECODE)) {
            NativeCmdLine.testDecode(inputFile, encodings);
        } else {
            cmd.showUsage();
            return;
        }
    }

    public static void testEncode(File input, String[] encodings) {
        try {
            Iterator<String> data = Datafile.getIterator(input);
            if (encodings != null && encodings.length == 1) {
                while (data.hasNext()) {
                    NativeCmdLine.testEncode(data.next(), encodings[0]);
                }
            } else {
                while (data.hasNext()) {
                    NativeCmdLine.testEncode(data.next(), encodings);
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static void testDecode(File input, String[] encodings) {
        try {
            Iterator<String> data = Datafile.getIterator(input);
            if (encodings != null && encodings.length == 1) {
                while (data.hasNext()) {
                    NativeCmdLine.testDecode(data.next(), encodings[0]);
                }
            } else {
                while (data.hasNext()) {
                    NativeCmdLine.testDecode(data.next(), encodings);
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static void testEncode(String input, String encoding) throws XcodeException {
        String inputdecoded = null;
        String output = null;
        if (input == null) {
            Debug.pass("");
            return;
        }
        String inputString = input.trim();
        if (inputString.length() == 0 || inputString.charAt(0) == '#') {
            Debug.pass(inputString);
            return;
        }
        try {
            inputdecoded = new String(Hex.decodeChars(inputString));
            output = Native.encode(inputdecoded, encoding);
        }
        catch (XcodeException x) {
            Debug.fail(inputString + "\tERROR:" + x.getCode() + "\t" + x.getMessage());
            return;
        }
        System.out.println(Hex.encode(output.toCharArray()));
    }

    public static void testEncode(String input, String[] encodings) throws XcodeException {
        String inputdecoded = null;
        Map<String, String> output = null;
        String variant = null;
        if (input == null) {
            Debug.pass("");
            return;
        }
        String inputString = input.trim();
        if (inputString.length() == 0 || inputString.charAt(0) == '#') {
            Debug.pass(inputString);
            return;
        }
        try {
            inputdecoded = new String(Hex.decodeChars(inputString));
            output = encodings == null || encodings.length == 0 ? Native.encode(inputdecoded) : Native.encode(inputdecoded, encodings);
        }
        catch (XcodeException x) {
            Debug.fail(inputString + "\tERROR:" + x.getCode() + "\t" + x.getMessage());
            return;
        }
        System.out.println(inputString);
        Iterator<String> i = output.keySet().iterator();
        String encoding = null;
        while (i.hasNext()) {
            encoding = i.next();
            variant = output.get(encoding);
            System.out.println("\t" + encoding + "\t" + Hex.encode(variant.toCharArray()));
        }
        System.out.println(output.size());
    }

    public static void testDecode(String input, String encoding) throws XcodeException {
        byte[] inputarray = null;
        String output = null;
        if (input == null) {
            Debug.pass("");
            return;
        }
        String inputString = input.trim();
        if (inputString.length() == 0 || inputString.charAt(0) == '#') {
            Debug.pass(inputString);
            return;
        }
        try {
            inputarray = Hex.decodeBytes(inputString);
            output = Native.decode(inputarray, encoding);
        }
        catch (XcodeException x) {
            Debug.fail(inputString + "\tERROR:" + x.getCode() + "\t" + x.getMessage());
            return;
        }
        System.out.println(Hex.encode(output.toCharArray()));
    }

    public static void testDecode(String input, String[] encodings) throws XcodeException {
        byte[] inputarray = null;
        Map<String, String> output = null;
        String variant = null;
        if (input == null) {
            Debug.pass("");
            return;
        }
        String inputString = input.trim();
        if (inputString.length() == 0 || inputString.charAt(0) == '#') {
            Debug.pass(inputString);
            return;
        }
        try {
            inputarray = Hex.decodeBytes(inputString);
            output = encodings == null || encodings.length == 0 ? Native.decode(inputarray) : Native.decode(inputarray, encodings);
        }
        catch (XcodeException x) {
            Debug.fail(inputString + "\tERROR:" + x.getCode() + "\t" + x.getMessage());
            return;
        }
        System.out.println(inputString);
        Iterator<String> i = output.keySet().iterator();
        String encoding = null;
        while (i.hasNext()) {
            encoding = i.next();
            variant = output.get(encoding);
            System.out.println("\t" + encoding + "\t" + Hex.encode(variant.toCharArray()));
        }
        System.out.println(output.size());
    }

    @Override
    public String getUsageOptions() {
        return "(--encode | --decode) file=<file> <space separated encoding list>";
    }
}

