/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.cmdline.common;

import com.vgrs.xcode.cmdline.CmdLine;
import com.vgrs.xcode.cmdline.CommandLineArgs;
import com.vgrs.xcode.common.Hex;
import com.vgrs.xcode.common.Unicode;
import com.vgrs.xcode.util.Datafile;
import com.vgrs.xcode.util.Debug;
import com.vgrs.xcode.util.XcodeException;
import java.io.File;
import java.util.Iterator;

public class HexCmdLine
extends CmdLine {
    private static String SWITCH_ENCODE = "encode";
    private static String SWITCH_DECODE = "decode";

    public HexCmdLine(String[] args) {
        super(args);
    }

    @Override
    public String getUsageOptions() {
        return "(--encode | --decode) file=<file>";
    }

    public static void main(String[] args) {
        HexCmdLine cmd = new HexCmdLine(args);
        CommandLineArgs options = cmd.getOptions();
        if (options.getCount() == 2 && options.has("file")) {
            File inputFile = new File(options.get("file"));
            if (options.has(SWITCH_ENCODE)) {
                HexCmdLine.encode(inputFile);
                return;
            }
            if (options.has(SWITCH_DECODE)) {
                HexCmdLine.decode(inputFile);
                return;
            }
        }
        cmd.showUsage();
    }

    public static void encode(File input) {
        try {
            Iterator<String> data = Datafile.getIterator(input);
            while (data.hasNext()) {
                HexCmdLine.encode(data.next());
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static void decode(File input) {
        try {
            Iterator<String> data = Datafile.getIterator(input);
            while (data.hasNext()) {
                HexCmdLine.decode(data.next());
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static void encode(String input) {
        String output = null;
        if (input == null) {
            Debug.pass("");
            return;
        }
        if (input.length() == 0 || input.charAt(0) == '#') {
            Debug.pass(input);
            return;
        }
        try {
            output = Hex.encode(input.toCharArray());
        }
        catch (XcodeException x) {
            Debug.fail(input + "\tERROR:" + x.getCode() + "\t" + x.getMessage());
            return;
        }
        Debug.pass(output);
    }

    public static void decode(String input) {
        if (input == null) {
            Debug.pass("");
            return;
        }
        String inputString = input.trim();
        if (inputString.length() == 0 || inputString.charAt(0) == '#') {
            Debug.pass(inputString);
            return;
        }
        try {
            System.out.println(new String(Hex.decodeBytes(inputString)));
        }
        catch (XcodeException x1) {
            try {
                System.out.println(new String(Hex.decodeChars(inputString)));
            }
            catch (XcodeException x2) {
                try {
                    System.out.println(new String(Unicode.decode(Hex.decodeInts(inputString))));
                }
                catch (XcodeException x3) {
                    Debug.fail(inputString + "\tERROR:" + x3.getCode() + "\t" + x3.getMessage());
                    return;
                }
            }
        }
    }
}

