/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.cmdline.common;

import com.vgrs.xcode.cmdline.CmdLine;
import com.vgrs.xcode.cmdline.CommandLineArgs;
import com.vgrs.xcode.common.Base32;
import com.vgrs.xcode.common.Hex;
import com.vgrs.xcode.util.Datafile;
import com.vgrs.xcode.util.Debug;
import com.vgrs.xcode.util.XcodeException;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;

public class Base32CmdLine
extends CmdLine {
    private static String SWITCH_ENCODE = "encode";
    private static String SWITCH_DECODE = "decode";

    public Base32CmdLine(String[] args) {
        super(args);
    }

    @Override
    public String getUsageOptions() {
        return "(--encode | --decode) file=<file>";
    }

    public static void main(String[] args) {
        Base32CmdLine cmd = new Base32CmdLine(args);
        CommandLineArgs options = cmd.getOptions();
        if (options.getCount() == 2 && options.has("file")) {
            File inputFile = new File(options.get("file"));
            if (options.has(SWITCH_ENCODE)) {
                Base32CmdLine.testEncode(inputFile);
                return;
            }
            if (options.has(SWITCH_DECODE)) {
                Base32CmdLine.testDecode(inputFile);
                return;
            }
        }
        cmd.showUsage();
    }

    public static void testEncode(File input) {
        try {
            Iterator<String> data = Datafile.getIterator(input);
            while (data.hasNext()) {
                Base32CmdLine.testEncode(data.next());
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static void testDecode(File input) {
        try {
            Iterator<String> data = Datafile.getIterator(input);
            while (data.hasNext()) {
                Base32CmdLine.testDecode(data.next());
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static void testEncode(String input) throws XcodeException {
        byte[] inputarray = null;
        char[] output = null;
        byte[] check = null;
        if (input == null) {
            Debug.pass("");
            return;
        }
        String inputString = input.trim();
        if (inputString.length() == 0 || inputString.charAt(0) == '#') {
            Debug.pass(inputString);
            return;
        }
        try {
            inputarray = Hex.decodeBytes(inputString);
            output = Base32.encode(inputarray);
        }
        catch (XcodeException x) {
            Debug.fail(inputString + "\tERROR:" + x.getCode() + "\t" + x.getMessage());
            return;
        }
        try {
            check = Base32.decode(output);
        }
        catch (XcodeException x) {
            Debug.fail(inputString + "\tFATAL:" + x.getCode() + "\t" + x.getMessage());
            return;
        }
        if (!Arrays.equals(inputarray, check)) {
            Debug.fail(inputString + "\tMISMATCH\t" + Hex.encode(check));
            return;
        }
        Debug.pass(new String(output));
    }

    public static void testDecode(String input) throws XcodeException {
        char[] inputarray = null;
        byte[] output = null;
        char[] check = null;
        if (input == null) {
            Debug.pass("");
            return;
        }
        String inputString = input.trim();
        if (inputString.length() == 0 || inputString.charAt(0) == '#') {
            Debug.pass(inputString);
            return;
        }
        inputarray = inputString.toCharArray();
        try {
            output = Base32.decode(inputarray);
        }
        catch (XcodeException x) {
            Debug.fail(inputString + "\tERROR:" + x.getCode() + "\t" + x.getMessage());
            return;
        }
        try {
            check = Base32.encode(output);
        }
        catch (XcodeException x) {
            Debug.fail(inputString + "\tFATAL:" + x.getCode() + "\t" + x.getMessage());
            return;
        }
        if (!input.equalsIgnoreCase(new String(check))) {
            Debug.fail(inputString + "\tMISMATCH\t" + new String(check));
            return;
        }
        Debug.pass(Hex.encode(output));
    }
}

