/*
 * Decompiled with CFR 0.152.
 */
package com.vgrs.xcode.cmdline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommandLineArgs {
    private static final int IC = 2;
    private static final String RX_KEY_VALUE = "^-*(.+)=(.+)$";
    private static final String RX_DOUBLE_FLAG = "^--(.+)$";
    private static final String RX_SINGLE_SWITCH = "^-(.+)";
    private static final Pattern PT_KEY_VALUE = Pattern.compile("^-*(.+)=(.+)$", 2);
    private static final Pattern PT_DOUBLE_FLAG = Pattern.compile("^--(.+)$", 2);
    private static final Pattern PT_SINGLE_SWITCH = Pattern.compile("^-(.+)", 2);
    private static final char ID_FILE = 'f';
    private HashMap<String, String> options;
    private ArrayList<String> unassigned;
    private int count;

    public CommandLineArgs() {
        this.reset();
    }

    public CommandLineArgs(String[] aArgs) {
        this();
        this.parse(aArgs);
    }

    public String get(String aOption) {
        return this.options.get(aOption);
    }

    public List<String> getUnassigned() {
        return this.unassigned;
    }

    public boolean has(String aOption) {
        return this.options.containsKey(aOption);
    }

    public void parse(String[] aArgs) {
        if (aArgs == null || aArgs.length == 0) {
            return;
        }
        this.count = aArgs.length;
        int last = 0;
        for (String arg : aArgs) {
            Matcher matcher = PT_KEY_VALUE.matcher(arg);
            if (matcher.matches()) {
                this.options.put(matcher.group(1), matcher.group(2));
                continue;
            }
            matcher = PT_DOUBLE_FLAG.matcher(arg);
            if (matcher.matches()) {
                this.options.put(matcher.group(1), null);
                continue;
            }
            matcher = PT_SINGLE_SWITCH.matcher(arg);
            if (matcher.matches()) {
                char[] flags;
                for (int n : flags = matcher.group(1).toCharArray()) {
                    this.options.put("" + (char)n, null);
                    last = n;
                }
                continue;
            }
            if (last == 102) {
                this.options.put("f", arg);
                last = 0;
                continue;
            }
            this.unassigned.add(arg);
        }
    }

    public void reset() {
        this.options = new HashMap();
        this.unassigned = new ArrayList();
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("Options: " + this.options);
        out.append("\nUnassigned: " + this.unassigned);
        return out.toString();
    }

    public int getCount() {
        return this.count;
    }

    public Set<String> getOptionSet() {
        return this.options.keySet();
    }
}

